/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.maybe;

import java.util.concurrent.atomic.AtomicInteger;
import nakadi.shadow.io.reactivex.MaybeObserver;
import nakadi.shadow.io.reactivex.MaybeSource;
import nakadi.shadow.io.reactivex.annotations.Experimental;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Action;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.operators.maybe.AbstractMaybeWithUpstream;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

@Experimental
public final class MaybeDoFinally<T>
extends AbstractMaybeWithUpstream<T, T> {
    final Action onFinally;

    public MaybeDoFinally(MaybeSource<T> source, Action onFinally) {
        super(source);
        this.onFinally = onFinally;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> s) {
        this.source.subscribe(new DoFinallyObserver<T>(s, this.onFinally));
    }

    static final class DoFinallyObserver<T>
    extends AtomicInteger
    implements MaybeObserver<T>,
    Disposable {
        private static final long serialVersionUID = 4109457741734051389L;
        final MaybeObserver<? super T> actual;
        final Action onFinally;
        Disposable d;

        DoFinallyObserver(MaybeObserver<? super T> actual, Action onFinally) {
            this.actual = actual;
            this.onFinally = onFinally;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T t) {
            this.actual.onSuccess(t);
            this.runFinally();
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
            this.runFinally();
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
            this.runFinally();
        }

        @Override
        public void dispose() {
            this.d.dispose();
            this.runFinally();
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        void runFinally() {
            if (this.compareAndSet(0, 1)) {
                try {
                    this.onFinally.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }
    }
}

