/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Function;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.fuseable.QueueSubscription;
import nakadi.shadow.io.reactivex.internal.fuseable.SimpleQueue;
import nakadi.shadow.io.reactivex.internal.queue.SpscArrayQueue;
import nakadi.shadow.io.reactivex.internal.subscriptions.EmptySubscription;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.internal.util.AtomicThrowable;
import nakadi.shadow.io.reactivex.internal.util.BackpressureHelper;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;
import nakadi.shadow.org.reactivestreams.Publisher;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableZip<T, R>
extends Flowable<R> {
    final Publisher<? extends T>[] sources;
    final Iterable<? extends Publisher<? extends T>> sourcesIterable;
    final Function<? super Object[], ? extends R> zipper;
    final int bufferSize;
    final boolean delayError;

    public FlowableZip(Publisher<? extends T>[] sources, Iterable<? extends Publisher<? extends T>> sourcesIterable, Function<? super Object[], ? extends R> zipper, int bufferSize, boolean delayError) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.zipper = zipper;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Subscriber<? super R> s) {
        Publisher<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new Publisher[8];
            for (Publisher<? extends T> publisher : this.sourcesIterable) {
                if (count == sources.length) {
                    Publisher[] b = new Publisher[count + (count >> 2)];
                    System.arraycopy(sources, 0, b, 0, count);
                    sources = b;
                }
                sources[count++] = publisher;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptySubscription.complete(s);
            return;
        }
        ZipCoordinator<? extends T, R> coordinator = new ZipCoordinator<T, R>(s, this.zipper, count, this.bufferSize, this.delayError);
        s.onSubscribe(coordinator);
        coordinator.subscribe(sources, count);
    }

    static final class ZipSubscriber<T, R>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -4627193790118206028L;
        final ZipCoordinator<T, R> parent;
        final int prefetch;
        final int limit;
        SimpleQueue<T> queue;
        long produced;
        volatile boolean done;
        int sourceMode;

        ZipSubscriber(ZipCoordinator<T, R> parent, int prefetch) {
            this.parent = parent;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this, s)) {
                if (s instanceof QueueSubscription) {
                    QueueSubscription f = (QueueSubscription)s;
                    int m = f.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = f;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = f;
                        s.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                s.request(this.prefetch);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.sourceMode != 2) {
                this.queue.offer(t);
            }
            this.parent.drain();
        }

        @Override
        public void onError(Throwable t) {
            this.parent.error(this, t);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this);
        }

        @Override
        public void request(long n) {
            if (this.sourceMode != 1) {
                long p = this.produced + n;
                if (p >= (long)this.limit) {
                    this.produced = 0L;
                    ((Subscription)this.get()).request(p);
                } else {
                    this.produced = p;
                }
            }
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = -2434867452883857743L;
        final Subscriber<? super R> actual;
        final ZipSubscriber<T, R>[] subscribers;
        final Function<? super Object[], ? extends R> zipper;
        final AtomicLong requested;
        final AtomicThrowable errors;
        final boolean delayErrors;
        volatile boolean cancelled;
        final Object[] current;

        ZipCoordinator(Subscriber<? super R> actual, Function<? super Object[], ? extends R> zipper, int n, int prefetch, boolean delayErrors) {
            this.actual = actual;
            this.zipper = zipper;
            this.delayErrors = delayErrors;
            ZipSubscriber[] a = new ZipSubscriber[n];
            for (int i = 0; i < n; ++i) {
                a[i] = new ZipSubscriber(this, prefetch);
            }
            this.current = new Object[n];
            this.subscribers = a;
            this.requested = new AtomicLong();
            this.errors = new AtomicThrowable();
        }

        void subscribe(Publisher<? extends T>[] sources, int n) {
            ZipSubscriber<T, R>[] a = this.subscribers;
            for (int i = 0; i < n; ++i) {
                if (this.cancelled || !this.delayErrors && this.errors.get() != null) {
                    return;
                }
                sources[i].subscribe(a[i]);
            }
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
            }
        }

        void error(ZipSubscriber<T, R> inner, Throwable e) {
            if (this.errors.addThrowable(e)) {
                inner.done = true;
                this.drain();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        void cancelAll() {
            for (ZipSubscriber<T, R> s : this.subscribers) {
                s.cancel();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            Subscriber<R> a = this.actual;
            ZipSubscriber<T, R>[] qs = this.subscribers;
            int n = qs.length;
            Object[] values = this.current;
            int missed = 1;
            do {
                long e;
                long r = this.requested.get();
                for (e = 0L; r != e; ++e) {
                    R v;
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.delayErrors && this.errors.get() != null) {
                        this.cancelAll();
                        a.onError(this.errors.terminate());
                        return;
                    }
                    boolean empty = false;
                    for (int j = 0; j < n; ++j) {
                        ZipSubscriber<T, R> inner = qs[j];
                        if (values[j] != null) continue;
                        try {
                            boolean sourceEmpty;
                            boolean d = inner.done;
                            SimpleQueue q = inner.queue;
                            Object v2 = q != null ? q.poll() : null;
                            boolean bl = sourceEmpty = v2 == null;
                            if (d && sourceEmpty) {
                                this.cancelAll();
                                Throwable ex = (Throwable)this.errors.get();
                                if (ex != null) {
                                    a.onError(this.errors.terminate());
                                } else {
                                    a.onComplete();
                                }
                                return;
                            }
                            if (!sourceEmpty) {
                                values[j] = v2;
                                continue;
                            }
                            empty = true;
                            continue;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.errors.addThrowable(ex);
                            if (!this.delayErrors) {
                                this.cancelAll();
                                a.onError(this.errors.terminate());
                                return;
                            }
                            empty = true;
                        }
                    }
                    if (empty) break;
                    try {
                        v = ObjectHelper.requireNonNull(this.zipper.apply((Object[])values.clone()), "The zipper returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancelAll();
                        this.errors.addThrowable(ex);
                        a.onError(this.errors.terminate());
                        return;
                    }
                    a.onNext(v);
                    Arrays.fill(values, null);
                }
                if (r == e) {
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.delayErrors && this.errors.get() != null) {
                        this.cancelAll();
                        a.onError(this.errors.terminate());
                        return;
                    }
                    for (int j = 0; j < n; ++j) {
                        ZipSubscriber<T, R> inner = qs[j];
                        if (values[j] != null) continue;
                        try {
                            boolean empty;
                            boolean d = inner.done;
                            SimpleQueue q = inner.queue;
                            Object v = q != null ? q.poll() : null;
                            boolean bl = empty = v == null;
                            if (d && empty) {
                                this.cancelAll();
                                Throwable ex = (Throwable)this.errors.get();
                                if (ex != null) {
                                    a.onError(this.errors.terminate());
                                } else {
                                    a.onComplete();
                                }
                                return;
                            }
                            if (empty) continue;
                            values[j] = v;
                            continue;
                        }
                        catch (Throwable ex) {
                            Exceptions.throwIfFatal(ex);
                            this.errors.addThrowable(ex);
                            if (this.delayErrors) continue;
                            this.cancelAll();
                            a.onError(this.errors.terminate());
                            return;
                        }
                    }
                }
                if (e == 0L) continue;
                for (ZipSubscriber<T, R> inner : qs) {
                    inner.request(e);
                }
                if (r == Long.MAX_VALUE) continue;
                this.requested.addAndGet(-e);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

