/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.Collection;
import java.util.concurrent.Callable;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.Single;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.fuseable.FuseToFlowable;
import nakadi.shadow.io.reactivex.internal.operators.flowable.FlowableToList;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.internal.util.ArrayListSupplier;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableToListSingle<T, U extends Collection<? super T>>
extends Single<U>
implements FuseToFlowable<U> {
    final Flowable<T> source;
    final Callable<U> collectionSupplier;

    public FlowableToListSingle(Flowable<T> source) {
        this(source, ArrayListSupplier.asCallable());
    }

    public FlowableToListSingle(Flowable<T> source, Callable<U> collectionSupplier) {
        this.source = source;
        this.collectionSupplier = collectionSupplier;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super U> s) {
        Collection coll;
        try {
            coll = (Collection)ObjectHelper.requireNonNull(this.collectionSupplier.call(), "The collectionSupplier returned a null collection. Null values are generally not allowed in 2.x operators and sources.");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, s);
            return;
        }
        this.source.subscribe(new ToListSubscriber(s, coll));
    }

    @Override
    public Flowable<U> fuseToFlowable() {
        return RxJavaPlugins.onAssembly(new FlowableToList<T, U>(this.source, this.collectionSupplier));
    }

    static final class ToListSubscriber<T, U extends Collection<? super T>>
    implements FlowableSubscriber<T>,
    Disposable {
        final SingleObserver<? super U> actual;
        Subscription s;
        U value;

        ToListSubscriber(SingleObserver<? super U> actual, U collection) {
            this.actual = actual;
            this.value = collection;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.value.add(t);
        }

        @Override
        public void onError(Throwable t) {
            this.value = null;
            this.s = SubscriptionHelper.CANCELLED;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.s = SubscriptionHelper.CANCELLED;
            this.actual.onSuccess(this.value);
        }

        @Override
        public void dispose() {
            this.s.cancel();
            this.s = SubscriptionHelper.CANCELLED;
        }

        @Override
        public boolean isDisposed() {
            return this.s == SubscriptionHelper.CANCELLED;
        }
    }
}

