/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.Scheduler;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import nakadi.shadow.io.reactivex.internal.subscribers.FullArbiterSubscriber;
import nakadi.shadow.io.reactivex.internal.subscriptions.FullArbiter;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;
import nakadi.shadow.io.reactivex.subscribers.SerializedSubscriber;
import nakadi.shadow.org.reactivestreams.Publisher;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableTimeoutTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final Publisher<? extends T> other;
    static final Disposable NEW_TIMER = new EmptyDispose();

    public FlowableTimeoutTimed(Flowable<T> source, long timeout, TimeUnit unit, Scheduler scheduler, Publisher<? extends T> other) {
        super(source);
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (this.other == null) {
            this.source.subscribe(new TimeoutTimedSubscriber<T>(new SerializedSubscriber<T>(s), this.timeout, this.unit, this.scheduler.createWorker()));
        } else {
            this.source.subscribe(new TimeoutTimedOtherSubscriber<T>(s, this.timeout, this.unit, this.scheduler.createWorker(), this.other));
        }
    }

    static final class EmptyDispose
    implements Disposable {
        EmptyDispose() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return true;
        }
    }

    static final class TimeoutTimedSubscriber<T>
    implements FlowableSubscriber<T>,
    Disposable,
    Subscription {
        final Subscriber<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        Subscription s;
        final AtomicReference<Disposable> timer = new AtomicReference();
        volatile long index;
        volatile boolean done;

        TimeoutTimedSubscriber(Subscriber<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                this.scheduleTimeout(0L);
            }
        }

        @Override
        public void onNext(T t) {
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            this.actual.onNext(t);
            this.scheduleTimeout(idx);
        }

        void scheduleTimeout(long idx) {
            Disposable d = this.timer.get();
            if (d != null) {
                d.dispose();
            }
            if (this.timer.compareAndSet(d, NEW_TIMER)) {
                d = this.worker.schedule(new TimeoutTask(idx), this.timeout, this.unit);
                DisposableHelper.replace(this.timer, d);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
            this.worker.dispose();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
            this.worker.dispose();
        }

        @Override
        public void dispose() {
            this.s.cancel();
            this.worker.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.worker.isDisposed();
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.dispose();
        }

        final class TimeoutTask
        implements Runnable {
            private final long idx;

            TimeoutTask(long idx) {
                this.idx = idx;
            }

            @Override
            public void run() {
                if (this.idx == TimeoutTimedSubscriber.this.index) {
                    TimeoutTimedSubscriber.this.done = true;
                    TimeoutTimedSubscriber.this.dispose();
                    TimeoutTimedSubscriber.this.actual.onError(new TimeoutException());
                }
            }
        }
    }

    static final class TimeoutTimedOtherSubscriber<T>
    implements FlowableSubscriber<T>,
    Disposable {
        final Subscriber<? super T> actual;
        final long timeout;
        final TimeUnit unit;
        final Scheduler.Worker worker;
        final Publisher<? extends T> other;
        Subscription s;
        final FullArbiter<T> arbiter;
        final AtomicReference<Disposable> timer = new AtomicReference();
        volatile long index;
        volatile boolean done;

        TimeoutTimedOtherSubscriber(Subscriber<? super T> actual, long timeout, TimeUnit unit, Scheduler.Worker worker, Publisher<? extends T> other) {
            this.actual = actual;
            this.timeout = timeout;
            this.unit = unit;
            this.worker = worker;
            this.other = other;
            this.arbiter = new FullArbiter<T>(actual, this, 8);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                if (this.arbiter.setSubscription(s)) {
                    this.actual.onSubscribe(this.arbiter);
                    this.scheduleTimeout(0L);
                }
            }
        }

        @Override
        public void onNext(T t) {
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            if (this.arbiter.onNext(t, this.s)) {
                this.scheduleTimeout(idx);
            }
        }

        void scheduleTimeout(long idx) {
            Disposable d = this.timer.get();
            if (d != null) {
                d.dispose();
            }
            if (this.timer.compareAndSet(d, NEW_TIMER)) {
                d = this.worker.schedule(new TimeoutTask(idx), this.timeout, this.unit);
                DisposableHelper.replace(this.timer, d);
            }
        }

        void subscribeNext() {
            this.other.subscribe(new FullArbiterSubscriber<T>(this.arbiter));
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.arbiter.onError(t, this.s);
            this.worker.dispose();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.arbiter.onComplete(this.s);
            this.worker.dispose();
        }

        @Override
        public void dispose() {
            this.s.cancel();
            this.worker.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.worker.isDisposed();
        }

        final class TimeoutTask
        implements Runnable {
            private final long idx;

            TimeoutTask(long idx) {
                this.idx = idx;
            }

            @Override
            public void run() {
                if (this.idx == TimeoutTimedOtherSubscriber.this.index) {
                    TimeoutTimedOtherSubscriber.this.done = true;
                    TimeoutTimedOtherSubscriber.this.s.cancel();
                    DisposableHelper.dispose(TimeoutTimedOtherSubscriber.this.timer);
                    TimeoutTimedOtherSubscriber.this.subscribeNext();
                    TimeoutTimedOtherSubscriber.this.worker.dispose();
                }
            }
        }
    }
}

