/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Function;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import nakadi.shadow.io.reactivex.internal.subscribers.FullArbiterSubscriber;
import nakadi.shadow.io.reactivex.internal.subscriptions.FullArbiter;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;
import nakadi.shadow.io.reactivex.subscribers.DisposableSubscriber;
import nakadi.shadow.io.reactivex.subscribers.SerializedSubscriber;
import nakadi.shadow.org.reactivestreams.Publisher;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableTimeout<T, U, V>
extends AbstractFlowableWithUpstream<T, T> {
    final Publisher<U> firstTimeoutIndicator;
    final Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator;
    final Publisher<? extends T> other;

    public FlowableTimeout(Flowable<T> source, Publisher<U> firstTimeoutIndicator, Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator, Publisher<? extends T> other) {
        super(source);
        this.firstTimeoutIndicator = firstTimeoutIndicator;
        this.itemTimeoutIndicator = itemTimeoutIndicator;
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (this.other == null) {
            this.source.subscribe(new TimeoutSubscriber(new SerializedSubscriber<T>(s), this.firstTimeoutIndicator, this.itemTimeoutIndicator));
        } else {
            this.source.subscribe(new TimeoutOtherSubscriber(s, this.firstTimeoutIndicator, this.itemTimeoutIndicator, this.other));
        }
    }

    static final class TimeoutOtherSubscriber<T, U, V>
    implements FlowableSubscriber<T>,
    Disposable,
    OnTimeout {
        final Subscriber<? super T> actual;
        final Publisher<U> firstTimeoutIndicator;
        final Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator;
        final Publisher<? extends T> other;
        final FullArbiter<T> arbiter;
        Subscription s;
        boolean done;
        volatile boolean cancelled;
        volatile long index;
        final AtomicReference<Disposable> timeout = new AtomicReference();

        TimeoutOtherSubscriber(Subscriber<? super T> actual, Publisher<U> firstTimeoutIndicator, Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator, Publisher<? extends T> other) {
            this.actual = actual;
            this.firstTimeoutIndicator = firstTimeoutIndicator;
            this.itemTimeoutIndicator = itemTimeoutIndicator;
            this.other = other;
            this.arbiter = new FullArbiter<T>(actual, this, 8);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (!SubscriptionHelper.validate(this.s, s)) {
                return;
            }
            this.s = s;
            if (!this.arbiter.setSubscription(s)) {
                return;
            }
            Subscriber<T> a = this.actual;
            Publisher<U> p = this.firstTimeoutIndicator;
            if (p != null) {
                TimeoutInnerSubscriber tis = new TimeoutInnerSubscriber(this, 0L);
                if (this.timeout.compareAndSet(null, tis)) {
                    a.onSubscribe(this.arbiter);
                    p.subscribe(tis);
                }
            } else {
                a.onSubscribe(this.arbiter);
            }
        }

        @Override
        public void onNext(T t) {
            Publisher<V> p;
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            if (!this.arbiter.onNext(t, this.s)) {
                return;
            }
            Disposable d = this.timeout.get();
            if (d != null) {
                d.dispose();
            }
            try {
                p = ObjectHelper.requireNonNull(this.itemTimeoutIndicator.apply(t), "The publisher returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                return;
            }
            TimeoutInnerSubscriber tis = new TimeoutInnerSubscriber(this, idx);
            if (this.timeout.compareAndSet(d, tis)) {
                p.subscribe(tis);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.dispose();
            this.arbiter.onError(t, this.s);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.dispose();
            this.arbiter.onComplete(this.s);
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.s.cancel();
            DisposableHelper.dispose(this.timeout);
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void timeout(long idx) {
            if (idx == this.index) {
                this.dispose();
                this.other.subscribe(new FullArbiterSubscriber<T>(this.arbiter));
            }
        }
    }

    static final class TimeoutInnerSubscriber<T, U, V>
    extends DisposableSubscriber<Object> {
        final OnTimeout parent;
        final long index;
        boolean done;

        TimeoutInnerSubscriber(OnTimeout parent, long index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onNext(Object t) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.cancel();
            this.parent.timeout(this.index);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.parent.timeout(this.index);
        }
    }

    static interface OnTimeout {
        public void timeout(long var1);

        public void onError(Throwable var1);
    }

    static final class TimeoutSubscriber<T, U, V>
    implements FlowableSubscriber<T>,
    Subscription,
    OnTimeout {
        final Subscriber<? super T> actual;
        final Publisher<U> firstTimeoutIndicator;
        final Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator;
        Subscription s;
        volatile boolean cancelled;
        volatile long index;
        final AtomicReference<Disposable> timeout = new AtomicReference();

        TimeoutSubscriber(Subscriber<? super T> actual, Publisher<U> firstTimeoutIndicator, Function<? super T, ? extends Publisher<V>> itemTimeoutIndicator) {
            this.actual = actual;
            this.firstTimeoutIndicator = firstTimeoutIndicator;
            this.itemTimeoutIndicator = itemTimeoutIndicator;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (!SubscriptionHelper.validate(this.s, s)) {
                return;
            }
            this.s = s;
            if (this.cancelled) {
                return;
            }
            Subscriber<T> a = this.actual;
            Publisher<U> p = this.firstTimeoutIndicator;
            if (p != null) {
                TimeoutInnerSubscriber tis = new TimeoutInnerSubscriber(this, 0L);
                if (this.timeout.compareAndSet(null, tis)) {
                    a.onSubscribe(this);
                    p.subscribe(tis);
                }
            } else {
                a.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            Publisher<V> p;
            long idx;
            this.index = idx = this.index + 1L;
            this.actual.onNext(t);
            Disposable d = this.timeout.get();
            if (d != null) {
                d.dispose();
            }
            try {
                p = ObjectHelper.requireNonNull(this.itemTimeoutIndicator.apply(t), "The publisher returned is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancel();
                this.actual.onError(e);
                return;
            }
            TimeoutInnerSubscriber tis = new TimeoutInnerSubscriber(this, idx);
            if (this.timeout.compareAndSet(d, tis)) {
                p.subscribe(tis);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.cancel();
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.cancel();
            this.actual.onComplete();
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
            DisposableHelper.dispose(this.timeout);
        }

        @Override
        public void timeout(long idx) {
            if (idx == this.index) {
                this.cancel();
                this.actual.onError(new TimeoutException());
            }
        }
    }
}

