/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.internal.util.BackpressureHelper;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableTakeLast<T>
extends AbstractFlowableWithUpstream<T, T> {
    final int count;

    public FlowableTakeLast(Flowable<T> source, int count) {
        super(source);
        this.count = count;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new TakeLastSubscriber<T>(s, this.count));
    }

    static final class TakeLastSubscriber<T>
    extends ArrayDeque<T>
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 7240042530241604978L;
        final Subscriber<? super T> actual;
        final int count;
        Subscription s;
        volatile boolean done;
        volatile boolean cancelled;
        final AtomicLong requested = new AtomicLong();
        final AtomicInteger wip = new AtomicInteger();

        TakeLastSubscriber(Subscriber<? super T> actual, int count) {
            this.actual = actual;
            this.count = count;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.count == this.size()) {
                this.poll();
            }
            this.offer(t);
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
        }

        void drain() {
            if (this.wip.getAndIncrement() == 0) {
                Subscriber a = this.actual;
                long r = this.requested.get();
                do {
                    long e;
                    if (this.cancelled) {
                        return;
                    }
                    if (!this.done) continue;
                    for (e = 0L; e != r; ++e) {
                        if (this.cancelled) {
                            return;
                        }
                        Object v = this.poll();
                        if (v == null) {
                            a.onComplete();
                            return;
                        }
                        a.onNext(v);
                    }
                    if (e == 0L || r == Long.MAX_VALUE) continue;
                    r = this.requested.addAndGet(-e);
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }
}

