/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.NoSuchElementException;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.Single;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.fuseable.FuseToFlowable;
import nakadi.shadow.io.reactivex.internal.operators.flowable.FlowableSingle;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableSingleSingle<T>
extends Single<T>
implements FuseToFlowable<T> {
    final Flowable<T> source;
    final T defaultValue;

    public FlowableSingleSingle(Flowable<T> source, T defaultValue) {
        this.source = source;
        this.defaultValue = defaultValue;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> s) {
        this.source.subscribe((FlowableSubscriber<? super T>)new SingleElementSubscriber<T>(s, this.defaultValue));
    }

    @Override
    public Flowable<T> fuseToFlowable() {
        return RxJavaPlugins.onAssembly(new FlowableSingle<T>(this.source, this.defaultValue));
    }

    static final class SingleElementSubscriber<T>
    implements FlowableSubscriber<T>,
    Disposable {
        final SingleObserver<? super T> actual;
        final T defaultValue;
        Subscription s;
        boolean done;
        T value;

        SingleElementSubscriber(SingleObserver<? super T> actual, T defaultValue) {
            this.actual = actual;
            this.defaultValue = defaultValue;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.value != null) {
                this.done = true;
                this.s.cancel();
                this.s = SubscriptionHelper.CANCELLED;
                this.actual.onError(new IllegalArgumentException("Sequence contains more than one element!"));
                return;
            }
            this.value = t;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.s = SubscriptionHelper.CANCELLED;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.s = SubscriptionHelper.CANCELLED;
            T v = this.value;
            this.value = null;
            if (v == null) {
                v = this.defaultValue;
            }
            if (v != null) {
                this.actual.onSuccess(v);
            } else {
                this.actual.onError(new NoSuchElementException());
            }
        }

        @Override
        public void dispose() {
            this.s.cancel();
            this.s = SubscriptionHelper.CANCELLED;
        }

        @Override
        public boolean isDisposed() {
            return this.s == SubscriptionHelper.CANCELLED;
        }
    }
}

