/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.exceptions.MissingBackpressureException;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.internal.util.BackpressureHelper;
import nakadi.shadow.io.reactivex.subscribers.SerializedSubscriber;
import nakadi.shadow.org.reactivestreams.Publisher;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableSamplePublisher<T>
extends Flowable<T> {
    final Publisher<T> source;
    final Publisher<?> other;
    final boolean emitLast;

    public FlowableSamplePublisher(Publisher<T> source, Publisher<?> other, boolean emitLast) {
        this.source = source;
        this.other = other;
        this.emitLast = emitLast;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        SerializedSubscriber<? super T> serial = new SerializedSubscriber<T>(s);
        if (this.emitLast) {
            this.source.subscribe(new SampleMainEmitLast<T>(serial, this.other));
        } else {
            this.source.subscribe(new SampleMainNoLast<T>(serial, this.other));
        }
    }

    static final class SampleMainEmitLast<T>
    extends SamplePublisherSubscriber<T> {
        private static final long serialVersionUID = -3029755663834015785L;
        final AtomicInteger wip = new AtomicInteger();
        volatile boolean done;

        SampleMainEmitLast(Subscriber<? super T> actual, Publisher<?> other) {
            super(actual, other);
        }

        @Override
        void completeMain() {
            this.done = true;
            if (this.wip.getAndIncrement() == 0) {
                this.emit();
                this.actual.onComplete();
            }
        }

        @Override
        void completeOther() {
            this.done = true;
            if (this.wip.getAndIncrement() == 0) {
                this.emit();
                this.actual.onComplete();
            }
        }

        @Override
        void run() {
            if (this.wip.getAndIncrement() == 0) {
                do {
                    boolean d = this.done;
                    this.emit();
                    if (!d) continue;
                    this.actual.onComplete();
                    return;
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }

    static final class SampleMainNoLast<T>
    extends SamplePublisherSubscriber<T> {
        private static final long serialVersionUID = -3029755663834015785L;

        SampleMainNoLast(Subscriber<? super T> actual, Publisher<?> other) {
            super(actual, other);
        }

        @Override
        void completeMain() {
            this.actual.onComplete();
        }

        @Override
        void completeOther() {
            this.actual.onComplete();
        }

        @Override
        void run() {
            this.emit();
        }
    }

    static final class SamplerSubscriber<T>
    implements FlowableSubscriber<Object> {
        final SamplePublisherSubscriber<T> parent;

        SamplerSubscriber(SamplePublisherSubscriber<T> parent) {
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (this.parent.setOther(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(Object t) {
            this.parent.run();
        }

        @Override
        public void onError(Throwable t) {
            this.parent.error(t);
        }

        @Override
        public void onComplete() {
            this.parent.complete();
        }
    }

    static abstract class SamplePublisherSubscriber<T>
    extends AtomicReference<T>
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -3517602651313910099L;
        final Subscriber<? super T> actual;
        final Publisher<?> sampler;
        final AtomicLong requested = new AtomicLong();
        final AtomicReference<Subscription> other = new AtomicReference();
        Subscription s;

        SamplePublisherSubscriber(Subscriber<? super T> actual, Publisher<?> other) {
            this.actual = actual;
            this.sampler = other;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                if (this.other.get() == null) {
                    this.sampler.subscribe(new SamplerSubscriber(this));
                    s.request(Long.MAX_VALUE);
                }
            }
        }

        @Override
        public void onNext(T t) {
            this.lazySet(t);
        }

        @Override
        public void onError(Throwable t) {
            SubscriptionHelper.cancel(this.other);
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            SubscriptionHelper.cancel(this.other);
            this.completeMain();
        }

        boolean setOther(Subscription o) {
            return SubscriptionHelper.setOnce(this.other, o);
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
            }
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.other);
            this.s.cancel();
        }

        public void error(Throwable e) {
            this.s.cancel();
            this.actual.onError(e);
        }

        public void complete() {
            this.s.cancel();
            this.completeOther();
        }

        void emit() {
            Object value = this.getAndSet(null);
            if (value != null) {
                long r = this.requested.get();
                if (r != 0L) {
                    this.actual.onNext(value);
                    BackpressureHelper.produced(this.requested, 1L);
                } else {
                    this.cancel();
                    this.actual.onError(new MissingBackpressureException("Couldn't emit value due to lack of requests!"));
                }
            }
        }

        abstract void completeMain();

        abstract void completeOther();

        abstract void run();
    }
}

