/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.exceptions.CompositeException;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Function;
import nakadi.shadow.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionArbiter;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;
import nakadi.shadow.org.reactivestreams.Publisher;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableOnErrorNext<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier;
    final boolean allowFatal;

    public FlowableOnErrorNext(Flowable<T> source, Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier, boolean allowFatal) {
        super(source);
        this.nextSupplier = nextSupplier;
        this.allowFatal = allowFatal;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        OnErrorNextSubscriber<? super T> parent = new OnErrorNextSubscriber<T>(s, this.nextSupplier, this.allowFatal);
        s.onSubscribe(parent.arbiter);
        this.source.subscribe(parent);
    }

    static final class OnErrorNextSubscriber<T>
    implements FlowableSubscriber<T> {
        final Subscriber<? super T> actual;
        final Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier;
        final boolean allowFatal;
        final SubscriptionArbiter arbiter;
        boolean once;
        boolean done;

        OnErrorNextSubscriber(Subscriber<? super T> actual, Function<? super Throwable, ? extends Publisher<? extends T>> nextSupplier, boolean allowFatal) {
            this.actual = actual;
            this.nextSupplier = nextSupplier;
            this.allowFatal = allowFatal;
            this.arbiter = new SubscriptionArbiter();
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.arbiter.setSubscription(s);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            this.actual.onNext(t);
            if (!this.once) {
                this.arbiter.produced(1L);
            }
        }

        @Override
        public void onError(Throwable t) {
            Publisher<T> p;
            if (this.once) {
                if (this.done) {
                    RxJavaPlugins.onError(t);
                    return;
                }
                this.actual.onError(t);
                return;
            }
            this.once = true;
            if (this.allowFatal && !(t instanceof Exception)) {
                this.actual.onError(t);
                return;
            }
            try {
                p = this.nextSupplier.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(new CompositeException(t, e));
                return;
            }
            if (p == null) {
                NullPointerException npe = new NullPointerException("Publisher is null");
                npe.initCause(t);
                this.actual.onError(npe);
                return;
            }
            p.subscribe(this);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.once = true;
            this.actual.onComplete();
        }
    }
}

