/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.concurrent.atomic.AtomicLong;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.annotations.Nullable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.exceptions.MissingBackpressureException;
import nakadi.shadow.io.reactivex.functions.Action;
import nakadi.shadow.io.reactivex.internal.fuseable.SimplePlainQueue;
import nakadi.shadow.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import nakadi.shadow.io.reactivex.internal.queue.SpscArrayQueue;
import nakadi.shadow.io.reactivex.internal.queue.SpscLinkedArrayQueue;
import nakadi.shadow.io.reactivex.internal.subscriptions.BasicIntQueueSubscription;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.internal.util.BackpressureHelper;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableOnBackpressureBuffer<T>
extends AbstractFlowableWithUpstream<T, T> {
    final int bufferSize;
    final boolean unbounded;
    final boolean delayError;
    final Action onOverflow;

    public FlowableOnBackpressureBuffer(Flowable<T> source, int bufferSize, boolean unbounded, boolean delayError, Action onOverflow) {
        super(source);
        this.bufferSize = bufferSize;
        this.unbounded = unbounded;
        this.delayError = delayError;
        this.onOverflow = onOverflow;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new BackpressureBufferSubscriber<T>(s, this.bufferSize, this.unbounded, this.delayError, this.onOverflow));
    }

    static final class BackpressureBufferSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -2514538129242366402L;
        final Subscriber<? super T> actual;
        final SimplePlainQueue<T> queue;
        final boolean delayError;
        final Action onOverflow;
        Subscription s;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        final AtomicLong requested = new AtomicLong();
        boolean outputFused;

        BackpressureBufferSubscriber(Subscriber<? super T> actual, int bufferSize, boolean unbounded, boolean delayError, Action onOverflow) {
            this.actual = actual;
            this.onOverflow = onOverflow;
            this.delayError = delayError;
            SimplePlainQueue<Object> q = unbounded ? new SpscLinkedArrayQueue(bufferSize) : new SpscArrayQueue(bufferSize);
            this.queue = q;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                this.s.cancel();
                MissingBackpressureException ex = new MissingBackpressureException("Buffer is full");
                try {
                    this.onOverflow.run();
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    ex.initCause(e);
                }
                this.onError(ex);
                return;
            }
            if (this.outputFused) {
                this.actual.onNext(null);
            } else {
                this.drain();
            }
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            if (this.outputFused) {
                this.actual.onError(t);
            } else {
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            if (this.outputFused) {
                this.actual.onComplete();
            } else {
                this.drain();
            }
        }

        @Override
        public void request(long n) {
            if (!this.outputFused && SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        void drain() {
            block5: {
                if (this.getAndIncrement() != 0) break block5;
                int missed = 1;
                SimplePlainQueue<T> q = this.queue;
                Subscriber<T> a = this.actual;
                do {
                    boolean empty;
                    boolean d;
                    long e;
                    if (this.checkTerminated(this.done, q.isEmpty(), a)) {
                        return;
                    }
                    long r = this.requested.get();
                    for (e = 0L; e != r; ++e) {
                        boolean empty2;
                        d = this.done;
                        T v = q.poll();
                        boolean bl = empty2 = v == null;
                        if (this.checkTerminated(d, empty2, a)) {
                            return;
                        }
                        if (empty2) break;
                        a.onNext(v);
                    }
                    if (e == r && this.checkTerminated(d = this.done, empty = q.isEmpty(), a)) {
                        return;
                    }
                    if (e == 0L || r == Long.MAX_VALUE) continue;
                    this.requested.addAndGet(-e);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a) {
            if (this.cancelled) {
                this.queue.clear();
                return true;
            }
            if (d) {
                if (this.delayError) {
                    if (empty) {
                        Throwable e = this.error;
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.queue.clear();
                        a.onError(e);
                        return true;
                    }
                    if (empty) {
                        a.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public int requestFusion(int mode) {
            if ((mode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        @Nullable
        public T poll() throws Exception {
            return this.queue.poll();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }
}

