/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.Maybe;
import nakadi.shadow.io.reactivex.MaybeObserver;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.org.reactivestreams.Publisher;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableLastMaybe<T>
extends Maybe<T> {
    final Publisher<T> source;

    public FlowableLastMaybe(Publisher<T> source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new LastSubscriber<T>(observer));
    }

    static final class LastSubscriber<T>
    implements FlowableSubscriber<T>,
    Disposable {
        final MaybeObserver<? super T> actual;
        Subscription s;
        T item;

        LastSubscriber(MaybeObserver<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public void dispose() {
            this.s.cancel();
            this.s = SubscriptionHelper.CANCELLED;
        }

        @Override
        public boolean isDisposed() {
            return this.s == SubscriptionHelper.CANCELLED;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.item = t;
        }

        @Override
        public void onError(Throwable t) {
            this.s = SubscriptionHelper.CANCELLED;
            this.item = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.s = SubscriptionHelper.CANCELLED;
            T v = this.item;
            if (v != null) {
                this.item = null;
                this.actual.onSuccess(v);
            } else {
                this.actual.onComplete();
            }
        }
    }
}

