/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.Observable;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableFromObservable<T>
extends Flowable<T> {
    private final Observable<T> upstream;

    public FlowableFromObservable(Observable<T> upstream) {
        this.upstream = upstream;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.upstream.subscribe(new SubscriberObserver<T>(s));
    }

    static class SubscriberObserver<T>
    implements Observer<T>,
    Subscription {
        private final Subscriber<? super T> s;
        private Disposable d;

        SubscriberObserver(Subscriber<? super T> s) {
            this.s = s;
        }

        @Override
        public void onComplete() {
            this.s.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            this.s.onError(e);
        }

        @Override
        public void onNext(T value) {
            this.s.onNext(value);
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.d = d;
            this.s.onSubscribe(this);
        }

        @Override
        public void cancel() {
            this.d.dispose();
        }

        @Override
        public void request(long n) {
        }
    }
}

