/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import nakadi.shadow.org.reactivestreams.Subscriber;

public final class FlowableFromFuture<T>
extends Flowable<T> {
    final Future<? extends T> future;
    final long timeout;
    final TimeUnit unit;

    public FlowableFromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        T v;
        DeferredScalarSubscription<T> deferred = new DeferredScalarSubscription<T>(s);
        s.onSubscribe(deferred);
        try {
            v = this.unit != null ? this.future.get(this.timeout, this.unit) : this.future.get();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            if (!deferred.isCancelled()) {
                s.onError(ex);
            }
            return;
        }
        if (v == null) {
            s.onError(new NullPointerException("The future returned null"));
        } else {
            deferred.complete(v);
        }
    }
}

