/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.annotations.Nullable;
import nakadi.shadow.io.reactivex.functions.Predicate;
import nakadi.shadow.io.reactivex.internal.fuseable.ConditionalSubscriber;
import nakadi.shadow.io.reactivex.internal.fuseable.QueueSubscription;
import nakadi.shadow.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import nakadi.shadow.io.reactivex.internal.subscribers.BasicFuseableConditionalSubscriber;
import nakadi.shadow.io.reactivex.internal.subscribers.BasicFuseableSubscriber;
import nakadi.shadow.org.reactivestreams.Subscriber;

public final class FlowableFilter<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Predicate<? super T> predicate;

    public FlowableFilter(Flowable<T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        if (s instanceof ConditionalSubscriber) {
            this.source.subscribe(new FilterConditionalSubscriber<T>((ConditionalSubscriber)s, this.predicate));
        } else {
            this.source.subscribe(new FilterSubscriber<T>(s, this.predicate));
        }
    }

    static final class FilterConditionalSubscriber<T>
    extends BasicFuseableConditionalSubscriber<T, T> {
        final Predicate<? super T> filter;

        FilterConditionalSubscriber(ConditionalSubscriber<? super T> actual, Predicate<? super T> filter) {
            super(actual);
            this.filter = filter;
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean b;
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                return this.actual.tryOnNext(null);
            }
            try {
                b = this.filter.test(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return true;
            }
            return b && this.actual.tryOnNext(t);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Exception {
            QueueSubscription qs = this.qs;
            Predicate f = this.filter;
            Object t;
            while ((t = qs.poll()) != null) {
                if (f.test(t)) {
                    return t;
                }
                if (this.sourceMode != 2) continue;
                qs.request(1L);
            }
            return null;
        }
    }

    static final class FilterSubscriber<T>
    extends BasicFuseableSubscriber<T, T>
    implements ConditionalSubscriber<T> {
        final Predicate<? super T> filter;

        FilterSubscriber(Subscriber<? super T> actual, Predicate<? super T> filter) {
            super(actual);
            this.filter = filter;
        }

        @Override
        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean b;
            if (this.done) {
                return false;
            }
            if (this.sourceMode != 0) {
                this.actual.onNext(null);
                return true;
            }
            try {
                b = this.filter.test(t);
            }
            catch (Throwable e) {
                this.fail(e);
                return true;
            }
            if (b) {
                this.actual.onNext(t);
            }
            return b;
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Exception {
            QueueSubscription qs = this.qs;
            Predicate f = this.filter;
            Object t;
            while ((t = qs.poll()) != null) {
                if (f.test(t)) {
                    return t;
                }
                if (this.sourceMode != 2) continue;
                qs.request(1L);
            }
            return null;
        }
    }
}

