/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.concurrent.TimeUnit;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.Scheduler;
import nakadi.shadow.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.subscribers.SerializedSubscriber;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableDelay<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean delayError;

    public FlowableDelay(Flowable<T> source, long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        super(source);
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> t) {
        Subscriber<? super T> s = this.delayError ? t : new SerializedSubscriber<T>(t);
        Scheduler.Worker w = this.scheduler.createWorker();
        this.source.subscribe(new DelaySubscriber<T>(s, this.delay, this.unit, w, this.delayError));
    }

    static final class DelaySubscriber<T>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final long delay;
        final TimeUnit unit;
        final Scheduler.Worker w;
        final boolean delayError;
        Subscription s;

        DelaySubscriber(Subscriber<? super T> actual, long delay, TimeUnit unit, Scheduler.Worker w, boolean delayError) {
            this.actual = actual;
            this.delay = delay;
            this.unit = unit;
            this.w = w;
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            this.w.schedule(new OnNext(t), this.delay, this.unit);
        }

        @Override
        public void onError(Throwable t) {
            this.w.schedule(new OnError(t), this.delayError ? this.delay : 0L, this.unit);
        }

        @Override
        public void onComplete() {
            this.w.schedule(new OnComplete(), this.delay, this.unit);
        }

        @Override
        public void request(long n) {
            this.s.request(n);
        }

        @Override
        public void cancel() {
            this.s.cancel();
            this.w.dispose();
        }

        final class OnComplete
        implements Runnable {
            OnComplete() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DelaySubscriber.this.actual.onComplete();
                }
                finally {
                    DelaySubscriber.this.w.dispose();
                }
            }
        }

        final class OnError
        implements Runnable {
            private final Throwable t;

            OnError(Throwable t) {
                this.t = t;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DelaySubscriber.this.actual.onError(this.t);
                }
                finally {
                    DelaySubscriber.this.w.dispose();
                }
            }
        }

        final class OnNext
        implements Runnable {
            private final T t;

            OnNext(T t) {
                this.t = t;
            }

            @Override
            public void run() {
                DelaySubscriber.this.actual.onNext(this.t);
            }
        }
    }
}

