/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.concurrent.Callable;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.subscriptions.EmptySubscription;
import nakadi.shadow.org.reactivestreams.Publisher;
import nakadi.shadow.org.reactivestreams.Subscriber;

public final class FlowableDefer<T>
extends Flowable<T> {
    final Callable<? extends Publisher<? extends T>> supplier;

    public FlowableDefer(Callable<? extends Publisher<? extends T>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Publisher<? super T> pub;
        try {
            pub = ObjectHelper.requireNonNull(this.supplier.call(), "The publisher supplied is null");
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal(t);
            EmptySubscription.error(t, s);
            return;
        }
        pub.subscribe(s);
    }
}

