/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.exceptions.MissingBackpressureException;
import nakadi.shadow.io.reactivex.functions.Function;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.internal.util.BackpressureHelper;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;
import nakadi.shadow.io.reactivex.subscribers.DisposableSubscriber;
import nakadi.shadow.io.reactivex.subscribers.SerializedSubscriber;
import nakadi.shadow.org.reactivestreams.Publisher;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableDebounce<T, U>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super T, ? extends Publisher<U>> debounceSelector;

    public FlowableDebounce(Flowable<T> source, Function<? super T, ? extends Publisher<U>> debounceSelector) {
        super(source);
        this.debounceSelector = debounceSelector;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new DebounceSubscriber(new SerializedSubscriber<T>(s), this.debounceSelector));
    }

    static final class DebounceSubscriber<T, U>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 6725975399620862591L;
        final Subscriber<? super T> actual;
        final Function<? super T, ? extends Publisher<U>> debounceSelector;
        Subscription s;
        final AtomicReference<Disposable> debouncer = new AtomicReference();
        volatile long index;
        boolean done;

        DebounceSubscriber(Subscriber<? super T> actual, Function<? super T, ? extends Publisher<U>> debounceSelector) {
            this.actual = actual;
            this.debounceSelector = debounceSelector;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            Publisher<U> p;
            long idx;
            if (this.done) {
                return;
            }
            this.index = idx = this.index + 1L;
            Disposable d = this.debouncer.get();
            if (d != null) {
                d.dispose();
            }
            try {
                p = ObjectHelper.requireNonNull(this.debounceSelector.apply(t), "The publisher supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancel();
                this.actual.onError(e);
                return;
            }
            DebounceInnerSubscriber dis = new DebounceInnerSubscriber(this, idx, t);
            if (this.debouncer.compareAndSet(d, dis)) {
                p.subscribe(dis);
            }
        }

        @Override
        public void onError(Throwable t) {
            DisposableHelper.dispose(this.debouncer);
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            Disposable d = this.debouncer.get();
            if (!DisposableHelper.isDisposed(d)) {
                DebounceInnerSubscriber dis = (DebounceInnerSubscriber)d;
                dis.emit();
                DisposableHelper.dispose(this.debouncer);
                this.actual.onComplete();
            }
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this, n);
            }
        }

        @Override
        public void cancel() {
            this.s.cancel();
            DisposableHelper.dispose(this.debouncer);
        }

        void emit(long idx, T value) {
            if (idx == this.index) {
                long r = this.get();
                if (r != 0L) {
                    this.actual.onNext(value);
                    BackpressureHelper.produced(this, 1L);
                } else {
                    this.cancel();
                    this.actual.onError(new MissingBackpressureException("Could not deliver value due to lack of requests"));
                }
            }
        }

        static final class DebounceInnerSubscriber<T, U>
        extends DisposableSubscriber<U> {
            final DebounceSubscriber<T, U> parent;
            final long index;
            final T value;
            boolean done;
            final AtomicBoolean once = new AtomicBoolean();

            DebounceInnerSubscriber(DebounceSubscriber<T, U> parent, long index, T value) {
                this.parent = parent;
                this.index = index;
                this.value = value;
            }

            @Override
            public void onNext(U t) {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.cancel();
                this.emit();
            }

            void emit() {
                if (this.once.compareAndSet(false, true)) {
                    this.parent.emit(this.index, this.value);
                }
            }

            @Override
            public void onError(Throwable t) {
                if (this.done) {
                    RxJavaPlugins.onError(t);
                    return;
                }
                this.done = true;
                this.parent.onError(t);
            }

            @Override
            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.emit();
            }
        }
    }
}

