/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import nakadi.shadow.io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableCount<T>
extends AbstractFlowableWithUpstream<T, Long> {
    public FlowableCount(Flowable<T> source) {
        super(source);
    }

    @Override
    protected void subscribeActual(Subscriber<? super Long> s) {
        this.source.subscribe(new CountSubscriber(s));
    }

    static final class CountSubscriber
    extends DeferredScalarSubscription<Long>
    implements FlowableSubscriber<Object> {
        private static final long serialVersionUID = 4973004223787171406L;
        Subscription s;
        long count;

        CountSubscriber(Subscriber<? super Long> actual) {
            super(actual);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(Object t) {
            ++this.count;
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            this.complete(this.count);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

