/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.Collection;
import java.util.concurrent.Callable;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import nakadi.shadow.io.reactivex.internal.queue.MpscLinkedQueue;
import nakadi.shadow.io.reactivex.internal.subscribers.QueueDrainSubscriber;
import nakadi.shadow.io.reactivex.internal.subscriptions.EmptySubscription;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.internal.util.QueueDrainHelper;
import nakadi.shadow.io.reactivex.subscribers.DisposableSubscriber;
import nakadi.shadow.io.reactivex.subscribers.SerializedSubscriber;
import nakadi.shadow.org.reactivestreams.Publisher;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class FlowableBufferExactBoundary<T, U extends Collection<? super T>, B>
extends AbstractFlowableWithUpstream<T, U> {
    final Publisher<B> boundary;
    final Callable<U> bufferSupplier;

    public FlowableBufferExactBoundary(Flowable<T> source, Publisher<B> boundary, Callable<U> bufferSupplier) {
        super(source);
        this.boundary = boundary;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s) {
        this.source.subscribe(new BufferExactBoundarySubscriber(new SerializedSubscriber<U>(s), this.bufferSupplier, this.boundary));
    }

    static final class BufferBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends DisposableSubscriber<B> {
        final BufferExactBoundarySubscriber<T, U, B> parent;

        BufferBoundarySubscriber(BufferExactBoundarySubscriber<T, U, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t) {
            this.parent.next();
        }

        @Override
        public void onError(Throwable t) {
            this.parent.onError(t);
        }

        @Override
        public void onComplete() {
            this.parent.onComplete();
        }
    }

    static final class BufferExactBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends QueueDrainSubscriber<T, U, U>
    implements FlowableSubscriber<T>,
    Subscription,
    Disposable {
        final Callable<U> bufferSupplier;
        final Publisher<B> boundary;
        Subscription s;
        Disposable other;
        U buffer;

        BufferExactBoundarySubscriber(Subscriber<? super U> actual, Callable<U> bufferSupplier, Publisher<B> boundary) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundary = boundary;
        }

        @Override
        public void onSubscribe(Subscription s) {
            BufferBoundarySubscriber bs;
            Collection b;
            if (!SubscriptionHelper.validate(this.s, s)) {
                return;
            }
            this.s = s;
            try {
                b = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancelled = true;
                s.cancel();
                EmptySubscription.error(e, this.actual);
                return;
            }
            this.buffer = b;
            this.other = bs = new BufferBoundarySubscriber(this);
            this.actual.onSubscribe(this);
            if (!this.cancelled) {
                s.request(Long.MAX_VALUE);
                this.boundary.subscribe(bs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                U b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.cancel();
            this.actual.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b;
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(this.queue, this.actual, false, this, this);
            }
        }

        @Override
        public void request(long n) {
            this.requested(n);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.other.dispose();
                this.s.cancel();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            U b;
            Collection next;
            try {
                next = (Collection)ObjectHelper.requireNonNull(this.bufferSupplier.call(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancel();
                this.actual.onError(e);
                return;
            }
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = next;
            }
            this.fastPathEmitMax(b, false, this);
        }

        @Override
        public void dispose() {
            this.cancel();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public boolean accept(Subscriber<? super U> a, U v) {
            this.actual.onNext(v);
            return true;
        }
    }
}

