/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.flowable;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import nakadi.shadow.io.reactivex.functions.Action;
import nakadi.shadow.io.reactivex.functions.Consumer;
import nakadi.shadow.io.reactivex.internal.functions.Functions;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.subscribers.BlockingSubscriber;
import nakadi.shadow.io.reactivex.internal.subscribers.LambdaSubscriber;
import nakadi.shadow.io.reactivex.internal.util.BlockingHelper;
import nakadi.shadow.io.reactivex.internal.util.BlockingIgnoringReceiver;
import nakadi.shadow.io.reactivex.internal.util.ExceptionHelper;
import nakadi.shadow.io.reactivex.internal.util.NotificationLite;
import nakadi.shadow.org.reactivestreams.Publisher;
import nakadi.shadow.org.reactivestreams.Subscriber;

public final class FlowableBlockingSubscribe {
    private FlowableBlockingSubscribe() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> void subscribe(Publisher<? extends T> o, Subscriber<? super T> subscriber) {
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BlockingSubscriber bs = new BlockingSubscriber((Queue<Object>)queue);
        o.subscribe(bs);
        try {
            while (!bs.isCancelled()) {
                Object v = queue.poll();
                if (v == null) {
                    if (bs.isCancelled()) break;
                    BlockingHelper.verifyNonBlocking();
                    v = queue.take();
                }
                if (!bs.isCancelled() && o != BlockingSubscriber.TERMINATED && !NotificationLite.acceptFull(v, subscriber)) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            bs.cancel();
            subscriber.onError(e);
        }
    }

    public static <T> void subscribe(Publisher<? extends T> o) {
        BlockingIgnoringReceiver callback = new BlockingIgnoringReceiver();
        LambdaSubscriber ls = new LambdaSubscriber(Functions.emptyConsumer(), callback, callback, Functions.REQUEST_MAX);
        o.subscribe(ls);
        BlockingHelper.awaitForComplete(callback, ls);
        Throwable e = callback.error;
        if (e != null) {
            throw ExceptionHelper.wrapOrThrow(e);
        }
    }

    public static <T> void subscribe(Publisher<? extends T> o, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        ObjectHelper.requireNonNull(onNext, "onNext is null");
        ObjectHelper.requireNonNull(onError, "onError is null");
        ObjectHelper.requireNonNull(onComplete, "onComplete is null");
        FlowableBlockingSubscribe.subscribe(o, new LambdaSubscriber<T>(onNext, onError, onComplete, Functions.REQUEST_MAX));
    }
}

