/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.completable;

import java.util.concurrent.Callable;
import nakadi.shadow.io.reactivex.CompletableObserver;
import nakadi.shadow.io.reactivex.CompletableSource;
import nakadi.shadow.io.reactivex.Single;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;

public final class CompletableToSingle<T>
extends Single<T> {
    final CompletableSource source;
    final Callable<? extends T> completionValueSupplier;
    final T completionValue;

    public CompletableToSingle(CompletableSource source, Callable<? extends T> completionValueSupplier, T completionValue) {
        this.source = source;
        this.completionValue = completionValue;
        this.completionValueSupplier = completionValueSupplier;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> s) {
        this.source.subscribe(new ToSingle(s));
    }

    final class ToSingle
    implements CompletableObserver {
        private final SingleObserver<? super T> observer;

        ToSingle(SingleObserver<? super T> observer) {
            this.observer = observer;
        }

        @Override
        public void onComplete() {
            Object v;
            if (CompletableToSingle.this.completionValueSupplier != null) {
                try {
                    v = CompletableToSingle.this.completionValueSupplier.call();
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.observer.onError(e);
                    return;
                }
            } else {
                v = CompletableToSingle.this.completionValue;
            }
            if (v == null) {
                this.observer.onError(new NullPointerException("The value supplied is null"));
            } else {
                this.observer.onSuccess(v);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.observer.onError(e);
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.observer.onSubscribe(d);
        }
    }
}

