/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.completable;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import nakadi.shadow.io.reactivex.Completable;
import nakadi.shadow.io.reactivex.CompletableObserver;
import nakadi.shadow.io.reactivex.CompletableSource;
import nakadi.shadow.io.reactivex.Scheduler;
import nakadi.shadow.io.reactivex.disposables.CompositeDisposable;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class CompletableTimeout
extends Completable {
    final CompletableSource source;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    final CompletableSource other;

    public CompletableTimeout(CompletableSource source, long timeout, TimeUnit unit, Scheduler scheduler, CompletableSource other) {
        this.source = source;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
        this.other = other;
    }

    @Override
    public void subscribeActual(CompletableObserver s) {
        CompositeDisposable set = new CompositeDisposable();
        s.onSubscribe(set);
        AtomicBoolean once = new AtomicBoolean();
        Disposable timer = this.scheduler.scheduleDirect(new DisposeTask(once, set, s), this.timeout, this.unit);
        set.add(timer);
        this.source.subscribe(new TimeOutObserver(set, once, s));
    }

    final class DisposeTask
    implements Runnable {
        private final AtomicBoolean once;
        final CompositeDisposable set;
        final CompletableObserver s;

        DisposeTask(AtomicBoolean once, CompositeDisposable set, CompletableObserver s) {
            this.once = once;
            this.set = set;
            this.s = s;
        }

        @Override
        public void run() {
            if (this.once.compareAndSet(false, true)) {
                this.set.clear();
                if (CompletableTimeout.this.other == null) {
                    this.s.onError(new TimeoutException());
                } else {
                    CompletableTimeout.this.other.subscribe(new DisposeObserver());
                }
            }
        }

        final class DisposeObserver
        implements CompletableObserver {
            DisposeObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposeTask.this.set.add(d);
            }

            @Override
            public void onError(Throwable e) {
                DisposeTask.this.set.dispose();
                DisposeTask.this.s.onError(e);
            }

            @Override
            public void onComplete() {
                DisposeTask.this.set.dispose();
                DisposeTask.this.s.onComplete();
            }
        }
    }

    static final class TimeOutObserver
    implements CompletableObserver {
        private final CompositeDisposable set;
        private final AtomicBoolean once;
        private final CompletableObserver s;

        TimeOutObserver(CompositeDisposable set, AtomicBoolean once, CompletableObserver s) {
            this.set = set;
            this.once = once;
            this.s = s;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.set.add(d);
        }

        @Override
        public void onError(Throwable e) {
            if (this.once.compareAndSet(false, true)) {
                this.set.dispose();
                this.s.onError(e);
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            if (this.once.compareAndSet(false, true)) {
                this.set.dispose();
                this.s.onComplete();
            }
        }
    }
}

