/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.completable;

import nakadi.shadow.io.reactivex.Completable;
import nakadi.shadow.io.reactivex.CompletableObserver;
import nakadi.shadow.io.reactivex.CompletableSource;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.CompositeException;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Function;
import nakadi.shadow.io.reactivex.internal.disposables.SequentialDisposable;

public final class CompletableResumeNext
extends Completable {
    final CompletableSource source;
    final Function<? super Throwable, ? extends CompletableSource> errorMapper;

    public CompletableResumeNext(CompletableSource source, Function<? super Throwable, ? extends CompletableSource> errorMapper) {
        this.source = source;
        this.errorMapper = errorMapper;
    }

    @Override
    protected void subscribeActual(CompletableObserver s) {
        SequentialDisposable sd = new SequentialDisposable();
        s.onSubscribe(sd);
        this.source.subscribe(new ResumeNext(s, sd));
    }

    final class ResumeNext
    implements CompletableObserver {
        final CompletableObserver s;
        final SequentialDisposable sd;

        ResumeNext(CompletableObserver s, SequentialDisposable sd) {
            this.s = s;
            this.sd = sd;
        }

        @Override
        public void onComplete() {
            this.s.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            CompletableSource c;
            try {
                c = CompletableResumeNext.this.errorMapper.apply(e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.s.onError(new CompositeException(ex, e));
                return;
            }
            if (c == null) {
                NullPointerException npe = new NullPointerException("The CompletableConsumable returned is null");
                npe.initCause(e);
                this.s.onError(npe);
                return;
            }
            c.subscribe(new OnErrorObserver());
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.sd.update(d);
        }

        final class OnErrorObserver
        implements CompletableObserver {
            OnErrorObserver() {
            }

            @Override
            public void onComplete() {
                ResumeNext.this.s.onComplete();
            }

            @Override
            public void onError(Throwable e) {
                ResumeNext.this.s.onError(e);
            }

            @Override
            public void onSubscribe(Disposable d) {
                ResumeNext.this.sd.update(d);
            }
        }
    }
}

