/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.completable;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import nakadi.shadow.io.reactivex.Completable;
import nakadi.shadow.io.reactivex.CompletableObserver;
import nakadi.shadow.io.reactivex.CompletableSource;
import nakadi.shadow.io.reactivex.disposables.CompositeDisposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.operators.completable.CompletableMergeDelayErrorArray;
import nakadi.shadow.io.reactivex.internal.util.AtomicThrowable;

public final class CompletableMergeDelayErrorIterable
extends Completable {
    final Iterable<? extends CompletableSource> sources;

    public CompletableMergeDelayErrorIterable(Iterable<? extends CompletableSource> sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver s) {
        Iterator<? extends CompletableSource> iterator;
        CompositeDisposable set = new CompositeDisposable();
        s.onSubscribe(set);
        try {
            iterator = ObjectHelper.requireNonNull(this.sources.iterator(), "The source iterator returned is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            s.onError(e);
            return;
        }
        AtomicInteger wip = new AtomicInteger(1);
        AtomicThrowable error = new AtomicThrowable();
        while (true) {
            CompletableSource c;
            boolean b;
            if (set.isDisposed()) {
                return;
            }
            try {
                b = iterator.hasNext();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                error.addThrowable(e);
                break;
            }
            if (!b) break;
            if (set.isDisposed()) {
                return;
            }
            try {
                c = ObjectHelper.requireNonNull(iterator.next(), "The iterator returned a null CompletableSource");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                error.addThrowable(e);
                break;
            }
            if (set.isDisposed()) {
                return;
            }
            wip.getAndIncrement();
            c.subscribe(new CompletableMergeDelayErrorArray.MergeInnerCompletableObserver(s, set, error, wip));
        }
        if (wip.decrementAndGet() == 0) {
            Throwable ex = error.terminate();
            if (ex == null) {
                s.onComplete();
            } else {
                s.onError(ex);
            }
        }
    }
}

