/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.completable;

import java.util.concurrent.atomic.AtomicInteger;
import nakadi.shadow.io.reactivex.Completable;
import nakadi.shadow.io.reactivex.CompletableObserver;
import nakadi.shadow.io.reactivex.CompletableSource;
import nakadi.shadow.io.reactivex.disposables.CompositeDisposable;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.util.AtomicThrowable;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class CompletableMergeDelayErrorArray
extends Completable {
    final CompletableSource[] sources;

    public CompletableMergeDelayErrorArray(CompletableSource[] sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver s) {
        CompositeDisposable set = new CompositeDisposable();
        AtomicInteger wip = new AtomicInteger(this.sources.length + 1);
        AtomicThrowable error = new AtomicThrowable();
        s.onSubscribe(set);
        for (CompletableSource c : this.sources) {
            if (set.isDisposed()) {
                return;
            }
            if (c == null) {
                NullPointerException ex = new NullPointerException("A completable source is null");
                error.addThrowable(ex);
                wip.decrementAndGet();
                continue;
            }
            c.subscribe(new MergeInnerCompletableObserver(s, set, error, wip));
        }
        if (wip.decrementAndGet() == 0) {
            Throwable ex = error.terminate();
            if (ex == null) {
                s.onComplete();
            } else {
                s.onError(ex);
            }
        }
    }

    static final class MergeInnerCompletableObserver
    implements CompletableObserver {
        final CompletableObserver actual;
        final CompositeDisposable set;
        final AtomicThrowable error;
        final AtomicInteger wip;

        MergeInnerCompletableObserver(CompletableObserver s, CompositeDisposable set, AtomicThrowable error, AtomicInteger wip) {
            this.actual = s;
            this.set = set;
            this.error = error;
            this.wip = wip;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.set.add(d);
        }

        @Override
        public void onError(Throwable e) {
            if (this.error.addThrowable(e)) {
                this.tryTerminate();
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.tryTerminate();
        }

        void tryTerminate() {
            if (this.wip.decrementAndGet() == 0) {
                Throwable ex = this.error.terminate();
                if (ex == null) {
                    this.actual.onComplete();
                } else {
                    this.actual.onError(ex);
                }
            }
        }
    }
}

