/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.completable;

import java.util.concurrent.Callable;
import nakadi.shadow.io.reactivex.Completable;
import nakadi.shadow.io.reactivex.CompletableObserver;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;

public final class CompletableErrorSupplier
extends Completable {
    final Callable<? extends Throwable> errorSupplier;

    public CompletableErrorSupplier(Callable<? extends Throwable> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Override
    protected void subscribeActual(CompletableObserver s) {
        Throwable error;
        try {
            error = ObjectHelper.requireNonNull(this.errorSupplier.call(), "The error returned is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            error = e;
        }
        EmptyDisposable.error(error, s);
    }
}

