/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.completable;

import nakadi.shadow.io.reactivex.Completable;
import nakadi.shadow.io.reactivex.CompletableObserver;
import nakadi.shadow.io.reactivex.CompletableSource;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.CompositeException;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Consumer;

public final class CompletableDoOnEvent
extends Completable {
    final CompletableSource source;
    final Consumer<? super Throwable> onEvent;

    public CompletableDoOnEvent(CompletableSource source, Consumer<? super Throwable> onEvent) {
        this.source = source;
        this.onEvent = onEvent;
    }

    @Override
    protected void subscribeActual(CompletableObserver s) {
        this.source.subscribe(new DoOnEvent(s));
    }

    final class DoOnEvent
    implements CompletableObserver {
        private final CompletableObserver observer;

        DoOnEvent(CompletableObserver observer) {
            this.observer = observer;
        }

        @Override
        public void onComplete() {
            try {
                CompletableDoOnEvent.this.onEvent.accept(null);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.observer.onError(e);
                return;
            }
            this.observer.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            try {
                CompletableDoOnEvent.this.onEvent.accept(e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                e = new CompositeException(e, ex);
            }
            this.observer.onError(e);
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.observer.onSubscribe(d);
        }
    }
}

