/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.completable;

import java.util.concurrent.atomic.AtomicInteger;
import nakadi.shadow.io.reactivex.Completable;
import nakadi.shadow.io.reactivex.CompletableObserver;
import nakadi.shadow.io.reactivex.CompletableSource;
import nakadi.shadow.io.reactivex.annotations.Experimental;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Action;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

@Experimental
public final class CompletableDoFinally
extends Completable {
    final CompletableSource source;
    final Action onFinally;

    public CompletableDoFinally(CompletableSource source, Action onFinally) {
        this.source = source;
        this.onFinally = onFinally;
    }

    @Override
    protected void subscribeActual(CompletableObserver s) {
        this.source.subscribe(new DoFinallyObserver(s, this.onFinally));
    }

    static final class DoFinallyObserver
    extends AtomicInteger
    implements CompletableObserver,
    Disposable {
        private static final long serialVersionUID = 4109457741734051389L;
        final CompletableObserver actual;
        final Action onFinally;
        Disposable d;

        DoFinallyObserver(CompletableObserver actual, Action onFinally) {
            this.actual = actual;
            this.onFinally = onFinally;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.d, d)) {
                this.d = d;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
            this.runFinally();
        }

        @Override
        public void onComplete() {
            this.actual.onComplete();
            this.runFinally();
        }

        @Override
        public void dispose() {
            this.d.dispose();
            this.runFinally();
        }

        @Override
        public boolean isDisposed() {
            return this.d.isDisposed();
        }

        void runFinally() {
            if (this.compareAndSet(0, 1)) {
                try {
                    this.onFinally.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }
    }
}

