/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.completable;

import java.util.concurrent.TimeUnit;
import nakadi.shadow.io.reactivex.Completable;
import nakadi.shadow.io.reactivex.CompletableObserver;
import nakadi.shadow.io.reactivex.CompletableSource;
import nakadi.shadow.io.reactivex.Scheduler;
import nakadi.shadow.io.reactivex.disposables.CompositeDisposable;
import nakadi.shadow.io.reactivex.disposables.Disposable;

public final class CompletableDelay
extends Completable {
    final CompletableSource source;
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean delayError;

    public CompletableDelay(CompletableSource source, long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        this.source = source;
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(CompletableObserver s) {
        CompositeDisposable set = new CompositeDisposable();
        this.source.subscribe(new Delay(set, s));
    }

    final class Delay
    implements CompletableObserver {
        private final CompositeDisposable set;
        final CompletableObserver s;

        Delay(CompositeDisposable set, CompletableObserver s) {
            this.set = set;
            this.s = s;
        }

        @Override
        public void onComplete() {
            this.set.add(CompletableDelay.this.scheduler.scheduleDirect(new OnComplete(), CompletableDelay.this.delay, CompletableDelay.this.unit));
        }

        @Override
        public void onError(Throwable e) {
            this.set.add(CompletableDelay.this.scheduler.scheduleDirect(new OnError(e), CompletableDelay.this.delayError ? CompletableDelay.this.delay : 0L, CompletableDelay.this.unit));
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.set.add(d);
            this.s.onSubscribe(this.set);
        }

        final class OnError
        implements Runnable {
            private final Throwable e;

            OnError(Throwable e) {
                this.e = e;
            }

            @Override
            public void run() {
                Delay.this.s.onError(this.e);
            }
        }

        final class OnComplete
        implements Runnable {
            OnComplete() {
            }

            @Override
            public void run() {
                Delay.this.s.onComplete();
            }
        }
    }
}

