/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.operators.completable;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Completable;
import nakadi.shadow.io.reactivex.CompletableObserver;
import nakadi.shadow.io.reactivex.CompletableSource;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableSubscriber;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.exceptions.MissingBackpressureException;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.fuseable.QueueSubscription;
import nakadi.shadow.io.reactivex.internal.fuseable.SimpleQueue;
import nakadi.shadow.io.reactivex.internal.queue.SpscArrayQueue;
import nakadi.shadow.io.reactivex.internal.queue.SpscLinkedArrayQueue;
import nakadi.shadow.io.reactivex.internal.subscriptions.SubscriptionHelper;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;
import nakadi.shadow.org.reactivestreams.Publisher;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class CompletableConcat
extends Completable {
    final Publisher<? extends CompletableSource> sources;
    final int prefetch;

    public CompletableConcat(Publisher<? extends CompletableSource> sources, int prefetch) {
        this.sources = sources;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(CompletableObserver s) {
        this.sources.subscribe(new CompletableConcatSubscriber(s, this.prefetch));
    }

    static final class CompletableConcatSubscriber
    extends AtomicInteger
    implements FlowableSubscriber<CompletableSource>,
    Disposable {
        private static final long serialVersionUID = 9032184911934499404L;
        final CompletableObserver actual;
        final int prefetch;
        final int limit;
        final ConcatInnerObserver inner;
        final AtomicBoolean once;
        int sourceFused;
        int consumed;
        SimpleQueue<CompletableSource> queue;
        Subscription s;
        volatile boolean done;
        volatile boolean active;

        CompletableConcatSubscriber(CompletableObserver actual, int prefetch) {
            this.actual = actual;
            this.prefetch = prefetch;
            this.inner = new ConcatInnerObserver(this);
            this.once = new AtomicBoolean();
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                long r;
                this.s = s;
                long l = r = this.prefetch == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)this.prefetch;
                if (s instanceof QueueSubscription) {
                    QueueSubscription qs = (QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceFused = m;
                        this.queue = qs;
                        this.done = true;
                        this.actual.onSubscribe(this);
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceFused = m;
                        this.queue = qs;
                        this.actual.onSubscribe(this);
                        s.request(r);
                        return;
                    }
                }
                this.queue = this.prefetch == Integer.MAX_VALUE ? new SpscLinkedArrayQueue<CompletableSource>(Flowable.bufferSize()) : new SpscArrayQueue<CompletableSource>(this.prefetch);
                this.actual.onSubscribe(this);
                s.request(r);
            }
        }

        @Override
        public void onNext(CompletableSource t) {
            if (this.sourceFused == 0 && !this.queue.offer(t)) {
                this.onError(new MissingBackpressureException());
                return;
            }
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            if (this.once.compareAndSet(false, true)) {
                DisposableHelper.dispose(this.inner);
                this.actual.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.s.cancel();
            DisposableHelper.dispose(this.inner);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.inner.get());
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            do {
                boolean empty;
                CompletableSource cs;
                if (this.isDisposed()) {
                    return;
                }
                if (this.active) continue;
                boolean d = this.done;
                try {
                    cs = this.queue.poll();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.innerError(ex);
                    return;
                }
                boolean bl = empty = cs == null;
                if (d && empty) {
                    if (this.once.compareAndSet(false, true)) {
                        this.actual.onComplete();
                    }
                    return;
                }
                if (empty) continue;
                this.active = true;
                cs.subscribe(this.inner);
                this.request();
            } while (this.decrementAndGet() != 0);
        }

        void request() {
            if (this.sourceFused != 1) {
                int p = this.consumed + 1;
                if (p == this.limit) {
                    this.consumed = 0;
                    this.s.request(p);
                } else {
                    this.consumed = p;
                }
            }
        }

        void innerError(Throwable e) {
            if (this.once.compareAndSet(false, true)) {
                this.s.cancel();
                this.actual.onError(e);
            } else {
                RxJavaPlugins.onError(e);
            }
        }

        void innerComplete() {
            this.active = false;
            this.drain();
        }

        static final class ConcatInnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver {
            private static final long serialVersionUID = -5454794857847146511L;
            final CompletableConcatSubscriber parent;

            ConcatInnerObserver(CompletableConcatSubscriber parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.replace(this, d);
            }

            @Override
            public void onError(Throwable e) {
                this.parent.innerError(e);
            }

            @Override
            public void onComplete() {
                this.parent.innerComplete();
            }
        }
    }
}

