/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.observers;

import nakadi.shadow.io.reactivex.CompletableObserver;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.org.reactivestreams.Subscriber;
import nakadi.shadow.org.reactivestreams.Subscription;

public final class SubscriberCompletableObserver<T>
implements CompletableObserver,
Subscription {
    final Subscriber<? super T> subscriber;
    Disposable d;

    public SubscriberCompletableObserver(Subscriber<? super T> observer) {
        this.subscriber = observer;
    }

    @Override
    public void onComplete() {
        this.subscriber.onComplete();
    }

    @Override
    public void onError(Throwable e) {
        this.subscriber.onError(e);
    }

    @Override
    public void onSubscribe(Disposable d) {
        if (DisposableHelper.validate(this.d, d)) {
            this.d = d;
            this.subscriber.onSubscribe(this);
        }
    }

    @Override
    public void request(long n) {
    }

    @Override
    public void cancel() {
        this.d.dispose();
    }
}

