/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.observers;

import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.fuseable.SimplePlainQueue;
import nakadi.shadow.io.reactivex.internal.observers.QueueDrainSubscriberPad2;
import nakadi.shadow.io.reactivex.internal.util.ObservableQueueDrain;
import nakadi.shadow.io.reactivex.internal.util.QueueDrainHelper;

public abstract class QueueDrainObserver<T, U, V>
extends QueueDrainSubscriberPad2
implements Observer<T>,
ObservableQueueDrain<U, V> {
    protected final Observer<? super V> actual;
    protected final SimplePlainQueue<U> queue;
    protected volatile boolean cancelled;
    protected volatile boolean done;
    protected Throwable error;

    public QueueDrainObserver(Observer<? super V> actual, SimplePlainQueue<U> queue) {
        this.actual = actual;
        this.queue = queue;
    }

    @Override
    public final boolean cancelled() {
        return this.cancelled;
    }

    @Override
    public final boolean done() {
        return this.done;
    }

    @Override
    public final boolean enter() {
        return this.wip.getAndIncrement() == 0;
    }

    public final boolean fastEnter() {
        return this.wip.get() == 0 && this.wip.compareAndSet(0, 1);
    }

    protected final void fastPathEmit(U value, boolean delayError, Disposable dispose) {
        Observer<? super V> s = this.actual;
        SimplePlainQueue<U> q = this.queue;
        if (this.wip.get() == 0 && this.wip.compareAndSet(0, 1)) {
            this.accept(s, value);
            if (this.leave(-1) == 0) {
                return;
            }
        } else {
            q.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainLoop(q, s, delayError, dispose, this);
    }

    protected final void fastPathOrderedEmit(U value, boolean delayError, Disposable disposable) {
        Observer<? super V> s = this.actual;
        SimplePlainQueue<U> q = this.queue;
        if (this.wip.get() == 0 && this.wip.compareAndSet(0, 1)) {
            if (q.isEmpty()) {
                this.accept(s, value);
                if (this.leave(-1) == 0) {
                    return;
                }
            } else {
                q.offer(value);
            }
        } else {
            q.offer(value);
            if (!this.enter()) {
                return;
            }
        }
        QueueDrainHelper.drainLoop(q, s, delayError, disposable, this);
    }

    @Override
    public final Throwable error() {
        return this.error;
    }

    @Override
    public final int leave(int m) {
        return this.wip.addAndGet(m);
    }

    @Override
    public void accept(Observer<? super V> a, U v) {
    }
}

