/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.observers;

import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.internal.util.BlockingHelper;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class FutureObserver<T>
extends CountDownLatch
implements Observer<T>,
Future<T>,
Disposable {
    T value;
    Throwable error;
    final AtomicReference<Disposable> s = new AtomicReference();

    public FutureObserver() {
        super(1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Disposable a;
        do {
            if ((a = this.s.get()) != this && a != DisposableHelper.DISPOSED) continue;
            return false;
        } while (!this.s.compareAndSet(a, DisposableHelper.DISPOSED));
        if (a != null) {
            a.dispose();
        }
        this.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return DisposableHelper.isDisposed(this.s.get());
    }

    @Override
    public boolean isDone() {
        return this.getCount() == 0L;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            this.await();
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex = this.error;
        if (ex != null) {
            throw new ExecutionException(ex);
        }
        return this.value;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.getCount() != 0L) {
            BlockingHelper.verifyNonBlocking();
            if (!this.await(timeout, unit)) {
                throw new TimeoutException();
            }
        }
        if (this.isCancelled()) {
            throw new CancellationException();
        }
        Throwable ex = this.error;
        if (ex != null) {
            throw new ExecutionException(ex);
        }
        return this.value;
    }

    @Override
    public void onSubscribe(Disposable s) {
        DisposableHelper.setOnce(this.s, s);
    }

    @Override
    public void onNext(T t) {
        if (this.value != null) {
            this.s.get().dispose();
            this.onError(new IndexOutOfBoundsException("More than one element received"));
            return;
        }
        this.value = t;
    }

    @Override
    public void onError(Throwable t) {
        if (this.error == null) {
            Disposable a;
            this.error = t;
            do {
                if ((a = this.s.get()) != this && a != DisposableHelper.DISPOSED) continue;
                RxJavaPlugins.onError(t);
                return;
            } while (!this.s.compareAndSet(a, this));
            this.countDown();
            return;
        }
        RxJavaPlugins.onError(t);
    }

    @Override
    public void onComplete() {
        Disposable a;
        if (this.value == null) {
            this.onError(new NoSuchElementException("The source is empty"));
            return;
        }
        do {
            if ((a = this.s.get()) != this && a != DisposableHelper.DISPOSED) continue;
            return;
        } while (!this.s.compareAndSet(a, this));
        this.countDown();
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean isDisposed() {
        return this.isDone();
    }
}

