/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.observers;

import java.util.concurrent.atomic.AtomicReference;
import nakadi.shadow.io.reactivex.SingleObserver;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.CompositeException;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.BiConsumer;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableHelper;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class BiConsumerSingleObserver<T>
extends AtomicReference<Disposable>
implements SingleObserver<T>,
Disposable {
    private static final long serialVersionUID = 4943102778943297569L;
    final BiConsumer<? super T, ? super Throwable> onCallback;

    public BiConsumerSingleObserver(BiConsumer<? super T, ? super Throwable> onCallback) {
        this.onCallback = onCallback;
    }

    @Override
    public void onError(Throwable e) {
        try {
            this.lazySet(DisposableHelper.DISPOSED);
            this.onCallback.accept(null, e);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(new CompositeException(e, ex));
        }
    }

    @Override
    public void onSubscribe(Disposable d) {
        DisposableHelper.setOnce(this, d);
    }

    @Override
    public void onSuccess(T value) {
        try {
            this.lazySet(DisposableHelper.DISPOSED);
            this.onCallback.accept(value, null);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(ex);
        }
    }

    @Override
    public void dispose() {
        DisposableHelper.dispose(this);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == DisposableHelper.DISPOSED;
    }
}

