/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.internal.disposables;

import nakadi.shadow.io.reactivex.Observer;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.internal.disposables.FullArbiterPad1;
import nakadi.shadow.io.reactivex.internal.queue.SpscLinkedArrayQueue;
import nakadi.shadow.io.reactivex.internal.util.NotificationLite;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public final class ObserverFullArbiter<T>
extends FullArbiterPad1
implements Disposable {
    final Observer<? super T> actual;
    final SpscLinkedArrayQueue<Object> queue;
    volatile Disposable s;
    Disposable resource;
    volatile boolean cancelled;

    public ObserverFullArbiter(Observer<? super T> actual, Disposable resource, int capacity) {
        this.actual = actual;
        this.resource = resource;
        this.queue = new SpscLinkedArrayQueue(capacity);
        this.s = EmptyDisposable.INSTANCE;
    }

    @Override
    public void dispose() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.disposeResource();
        }
    }

    @Override
    public boolean isDisposed() {
        Disposable d = this.resource;
        return d != null ? d.isDisposed() : this.cancelled;
    }

    void disposeResource() {
        Disposable d = this.resource;
        this.resource = null;
        if (d != null) {
            d.dispose();
        }
    }

    public boolean setDisposable(Disposable s) {
        if (this.cancelled) {
            return false;
        }
        this.queue.offer(this.s, NotificationLite.disposable(s));
        this.drain();
        return true;
    }

    public boolean onNext(T value, Disposable s) {
        if (this.cancelled) {
            return false;
        }
        this.queue.offer(s, NotificationLite.next(value));
        this.drain();
        return true;
    }

    public void onError(Throwable value, Disposable s) {
        if (this.cancelled) {
            RxJavaPlugins.onError(value);
            return;
        }
        this.queue.offer(s, NotificationLite.error(value));
        this.drain();
    }

    public void onComplete(Disposable s) {
        this.queue.offer(s, NotificationLite.complete());
        this.drain();
    }

    void drain() {
        if (this.wip.getAndIncrement() != 0) {
            return;
        }
        int missed = 1;
        SpscLinkedArrayQueue<Object> q = this.queue;
        Observer a = this.actual;
        while (true) {
            Object o;
            if ((o = q.poll()) != null) {
                Object v = q.poll();
                if (o != this.s) continue;
                if (NotificationLite.isDisposable(v)) {
                    Disposable next = NotificationLite.getDisposable(v);
                    this.s.dispose();
                    if (!this.cancelled) {
                        this.s = next;
                        continue;
                    }
                    next.dispose();
                    continue;
                }
                if (NotificationLite.isError(v)) {
                    q.clear();
                    this.disposeResource();
                    Throwable ex = NotificationLite.getError(v);
                    if (!this.cancelled) {
                        this.cancelled = true;
                        a.onError(ex);
                        continue;
                    }
                    RxJavaPlugins.onError(ex);
                    continue;
                }
                if (NotificationLite.isComplete(v)) {
                    q.clear();
                    this.disposeResource();
                    if (this.cancelled) continue;
                    this.cancelled = true;
                    a.onComplete();
                    continue;
                }
                a.onNext(NotificationLite.getValue(v));
                continue;
            }
            if ((missed = this.wip.addAndGet(-missed)) == 0) break;
        }
    }
}

