/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex.disposables;

import java.util.ArrayList;
import nakadi.shadow.io.reactivex.annotations.NonNull;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.CompositeException;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.internal.disposables.DisposableContainer;
import nakadi.shadow.io.reactivex.internal.functions.ObjectHelper;
import nakadi.shadow.io.reactivex.internal.util.ExceptionHelper;
import nakadi.shadow.io.reactivex.internal.util.OpenHashSet;

public final class CompositeDisposable
implements Disposable,
DisposableContainer {
    OpenHashSet<Disposable> resources;
    volatile boolean disposed;

    public CompositeDisposable() {
    }

    public CompositeDisposable(Disposable ... resources) {
        ObjectHelper.requireNonNull(resources, "resources is null");
        this.resources = new OpenHashSet(resources.length + 1);
        for (Disposable d : resources) {
            ObjectHelper.requireNonNull(d, "Disposable item is null");
            this.resources.add(d);
        }
    }

    public CompositeDisposable(@NonNull Iterable<? extends Disposable> resources) {
        ObjectHelper.requireNonNull(resources, "resources is null");
        this.resources = new OpenHashSet();
        for (Disposable disposable : resources) {
            ObjectHelper.requireNonNull(disposable, "Disposable item is null");
            this.resources.add(disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        OpenHashSet<Disposable> set;
        if (this.disposed) {
            return;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            set = this.resources;
            this.resources = null;
        }
        this.dispose(set);
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(@NonNull Disposable d) {
        ObjectHelper.requireNonNull(d, "d is null");
        if (!this.disposed) {
            CompositeDisposable compositeDisposable = this;
            synchronized (compositeDisposable) {
                if (!this.disposed) {
                    OpenHashSet<Disposable> set = this.resources;
                    if (set == null) {
                        this.resources = set = new OpenHashSet();
                    }
                    set.add(d);
                    return true;
                }
            }
        }
        d.dispose();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Disposable ... ds) {
        ObjectHelper.requireNonNull(ds, "ds is null");
        if (!this.disposed) {
            CompositeDisposable compositeDisposable = this;
            synchronized (compositeDisposable) {
                if (!this.disposed) {
                    OpenHashSet<Disposable> set = this.resources;
                    if (set == null) {
                        set = new OpenHashSet(ds.length + 1);
                        this.resources = set;
                    }
                    for (Disposable d : ds) {
                        ObjectHelper.requireNonNull(d, "d is null");
                        set.add(d);
                    }
                    return true;
                }
            }
        }
        for (Disposable d : ds) {
            d.dispose();
        }
        return false;
    }

    @Override
    public boolean remove(@NonNull Disposable d) {
        if (this.delete(d)) {
            d.dispose();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(@NonNull Disposable d) {
        ObjectHelper.requireNonNull(d, "Disposable item is null");
        if (this.disposed) {
            return false;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return false;
            }
            OpenHashSet<Disposable> set = this.resources;
            if (set == null || !set.remove(d)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        OpenHashSet<Disposable> set;
        if (this.disposed) {
            return;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return;
            }
            set = this.resources;
            this.resources = null;
        }
        this.dispose(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.disposed) {
            return 0;
        }
        CompositeDisposable compositeDisposable = this;
        synchronized (compositeDisposable) {
            if (this.disposed) {
                return 0;
            }
            OpenHashSet<Disposable> set = this.resources;
            int n = set != null ? set.size() : 0;
            return n;
        }
    }

    void dispose(OpenHashSet<Disposable> set) {
        Object[] array;
        if (set == null) {
            return;
        }
        ArrayList<Throwable> errors = null;
        for (Object o : array = set.keys()) {
            if (!(o instanceof Disposable)) continue;
            try {
                ((Disposable)o).dispose();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                if (errors == null) {
                    errors = new ArrayList<Throwable>();
                }
                errors.add(ex);
            }
        }
        if (errors != null) {
            if (errors.size() == 1) {
                throw ExceptionHelper.wrapOrThrow((Throwable)errors.get(0));
            }
            throw new CompositeException((Iterable<? extends Throwable>)errors);
        }
    }
}

