/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.io.reactivex;

import java.util.concurrent.TimeUnit;
import nakadi.shadow.io.reactivex.Completable;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.annotations.Experimental;
import nakadi.shadow.io.reactivex.annotations.NonNull;
import nakadi.shadow.io.reactivex.disposables.Disposable;
import nakadi.shadow.io.reactivex.exceptions.Exceptions;
import nakadi.shadow.io.reactivex.functions.Function;
import nakadi.shadow.io.reactivex.internal.disposables.EmptyDisposable;
import nakadi.shadow.io.reactivex.internal.disposables.SequentialDisposable;
import nakadi.shadow.io.reactivex.internal.schedulers.NewThreadWorker;
import nakadi.shadow.io.reactivex.internal.schedulers.SchedulerWhen;
import nakadi.shadow.io.reactivex.internal.util.ExceptionHelper;
import nakadi.shadow.io.reactivex.plugins.RxJavaPlugins;

public abstract class Scheduler {
    static final long CLOCK_DRIFT_TOLERANCE_NANOSECONDS = TimeUnit.MINUTES.toNanos(Long.getLong("nakadi.shadow.rx2.scheduler.drift-tolerance", 15L));

    public static long clockDriftTolerance() {
        return CLOCK_DRIFT_TOLERANCE_NANOSECONDS;
    }

    @NonNull
    public abstract Worker createWorker();

    public long now(@NonNull TimeUnit unit) {
        return unit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public void start() {
    }

    public void shutdown() {
    }

    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run) {
        return this.scheduleDirect(run, 0L, TimeUnit.NANOSECONDS);
    }

    @NonNull
    public Disposable scheduleDirect(@NonNull Runnable run, long delay, @NonNull TimeUnit unit) {
        Worker w = this.createWorker();
        Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
        DisposeTask task = new DisposeTask(decoratedRun, w);
        w.schedule(task, delay, unit);
        return task;
    }

    @NonNull
    public Disposable schedulePeriodicallyDirect(@NonNull Runnable run, long initialDelay, long period, @NonNull TimeUnit unit) {
        Runnable decoratedRun;
        PeriodicDirectTask periodicTask;
        Worker w = this.createWorker();
        Disposable d = w.schedulePeriodically(periodicTask = new PeriodicDirectTask(decoratedRun = RxJavaPlugins.onSchedule(run), w), initialDelay, period, unit);
        if (d == EmptyDisposable.INSTANCE) {
            return d;
        }
        return periodicTask;
    }

    @Experimental
    @NonNull
    public <S extends Scheduler> S when(@NonNull Function<Flowable<Flowable<Completable>>, Completable> combine) {
        return (S)new SchedulerWhen(combine, this);
    }

    static final class DisposeTask
    implements Runnable,
    Disposable {
        final Runnable decoratedRun;
        final Worker w;
        Thread runner;

        DisposeTask(Runnable decoratedRun, Worker w) {
            this.decoratedRun = decoratedRun;
            this.w = w;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.runner = Thread.currentThread();
            try {
                this.decoratedRun.run();
            }
            finally {
                this.dispose();
                this.runner = null;
            }
        }

        @Override
        public void dispose() {
            if (this.runner == Thread.currentThread() && this.w instanceof NewThreadWorker) {
                ((NewThreadWorker)this.w).shutdown();
            } else {
                this.w.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.w.isDisposed();
        }
    }

    static class PeriodicDirectTask
    implements Runnable,
    Disposable {
        final Runnable run;
        @NonNull
        final Worker worker;
        @NonNull
        volatile boolean disposed;

        PeriodicDirectTask(@NonNull Runnable run, @NonNull Worker worker) {
            this.run = run;
            this.worker = worker;
        }

        @Override
        public void run() {
            if (!this.disposed) {
                try {
                    this.run.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.worker.dispose();
                    throw ExceptionHelper.wrapOrThrow(ex);
                }
            }
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.worker.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }
    }

    public static abstract class Worker
    implements Disposable {
        @NonNull
        public Disposable schedule(@NonNull Runnable run) {
            return this.schedule(run, 0L, TimeUnit.NANOSECONDS);
        }

        @NonNull
        public abstract Disposable schedule(@NonNull Runnable var1, long var2, @NonNull TimeUnit var4);

        @NonNull
        public Disposable schedulePeriodically(@NonNull Runnable run, long initialDelay, long period, @NonNull TimeUnit unit) {
            SequentialDisposable first = new SequentialDisposable();
            SequentialDisposable sd = new SequentialDisposable(first);
            Runnable decoratedRun = RxJavaPlugins.onSchedule(run);
            long periodInNanoseconds = unit.toNanos(period);
            long firstNowNanoseconds = this.now(TimeUnit.NANOSECONDS);
            long firstStartInNanoseconds = firstNowNanoseconds + unit.toNanos(initialDelay);
            Disposable d = this.schedule(new PeriodicTask(firstStartInNanoseconds, decoratedRun, firstNowNanoseconds, sd, periodInNanoseconds), initialDelay, unit);
            if (d == EmptyDisposable.INSTANCE) {
                return d;
            }
            first.replace(d);
            return sd;
        }

        public long now(@NonNull TimeUnit unit) {
            return unit.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        final class PeriodicTask
        implements Runnable {
            @NonNull
            final Runnable decoratedRun;
            @NonNull
            final SequentialDisposable sd;
            final long periodInNanoseconds;
            long count;
            long lastNowNanoseconds;
            long startInNanoseconds;

            PeriodicTask(@NonNull long firstStartInNanoseconds, Runnable decoratedRun, @NonNull long firstNowNanoseconds, SequentialDisposable sd, long periodInNanoseconds) {
                this.decoratedRun = decoratedRun;
                this.sd = sd;
                this.periodInNanoseconds = periodInNanoseconds;
                this.lastNowNanoseconds = firstNowNanoseconds;
                this.startInNanoseconds = firstStartInNanoseconds;
            }

            @Override
            public void run() {
                this.decoratedRun.run();
                if (!this.sd.isDisposed()) {
                    long nextTick;
                    long nowNanoseconds = Worker.this.now(TimeUnit.NANOSECONDS);
                    if (nowNanoseconds + CLOCK_DRIFT_TOLERANCE_NANOSECONDS < this.lastNowNanoseconds || nowNanoseconds >= this.lastNowNanoseconds + this.periodInNanoseconds + CLOCK_DRIFT_TOLERANCE_NANOSECONDS) {
                        nextTick = nowNanoseconds + this.periodInNanoseconds;
                        this.startInNanoseconds = nextTick - this.periodInNanoseconds * ++this.count;
                    } else {
                        nextTick = this.startInNanoseconds + ++this.count * this.periodInNanoseconds;
                    }
                    this.lastNowNanoseconds = nowNanoseconds;
                    long delay = nextTick - nowNanoseconds;
                    this.sd.replace(Worker.this.schedule(this, delay, TimeUnit.NANOSECONDS));
                }
            }
        }
    }
}

