/*
 * Decompiled with CFR 0.152.
 */
package nakadi.shadow.com.google.common.collect;

import com.google.j2objc.annotations.Weak;
import nakadi.shadow.com.google.common.annotations.GwtCompatible;
import nakadi.shadow.com.google.common.annotations.GwtIncompatible;
import nakadi.shadow.com.google.common.collect.ImmutableAsList;
import nakadi.shadow.com.google.common.collect.ImmutableCollection;
import nakadi.shadow.com.google.common.collect.ImmutableList;
import nakadi.shadow.com.google.common.collect.UnmodifiableListIterator;

@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    @Weak
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible(value="not present in emulated superclass")
    int copyIntoArray(Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    public E get(int index) {
        return this.delegateList.get(index);
    }
}

