/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import nakadi.ClientException;
import nakadi.Problem;
import nakadi.QueryParams;

class UriBuilder {
    private static final String AND = "&";
    private static final String EQ = "=";
    private static Charset UTF_8 = StandardCharsets.UTF_8;
    private final QueryParams qp = new QueryParams();
    private StringBuilder stringBuilder;

    private UriBuilder(String uri) {
        try {
            URI tmp = new URI(uri);
            if (tmp.getQuery() != null) {
                String[] split;
                String query = tmp.getQuery();
                for (String s : split = query.split(AND)) {
                    String[] split1 = s.split(EQ);
                    this.qp.param(split1[0], split1[1]);
                }
                tmp = new URI(tmp.getScheme(), tmp.getUserInfo(), tmp.getHost(), tmp.getPort(), tmp.getPath(), null, tmp.getFragment());
            }
            this.stringBuilder = new StringBuilder(tmp.toASCIIString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private UriBuilder(URI uri) {
        this.stringBuilder = new StringBuilder(uri.toASCIIString());
    }

    public static UriBuilder builder(String uri) {
        return new UriBuilder(UriBuilder.rmTrailingSlash(uri));
    }

    private static String rmTrailingSlash(String uri) {
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    public static UriBuilder builder(URI uri) {
        return new UriBuilder(uri);
    }

    public UriBuilder path(String path) {
        this.stringBuilder.append("/").append(this.urlEncode(path));
        return this;
    }

    UriBuilder query(String param, String value) {
        this.qp.param(this.urlEncode(param), this.urlEncode(value));
        return this;
    }

    UriBuilder queryReplacing(String param, String value) {
        this.qp.paramReplacing(this.urlEncode(param), this.urlEncode(value));
        return this;
    }

    UriBuilder query(String param, String ... values) {
        String[] encodedValues = Arrays.stream(values).map(this::urlEncode).collect(Collectors.toList()).toArray(new String[0]);
        this.qp.param(this.urlEncode(param), encodedValues);
        return this;
    }

    UriBuilder query(QueryParams params) {
        params.params().forEach((key, value) -> {
            String[] encoded = value.stream().map(this::urlEncode).collect(Collectors.toList()).toArray(new String[0]);
            if (params.paramsToReplace().contains(key)) {
                this.qp.paramReplacing((String)key, encoded);
            } else {
                this.qp.param((String)key, encoded);
            }
        });
        return this;
    }

    String buildString() {
        return this.build().toASCIIString();
    }

    public URI build() {
        Map<String, Collection<String>> params = this.qp.params();
        if (!params.isEmpty()) {
            this.stringBuilder.append("?");
            StringBuilder sb = new StringBuilder();
            params.forEach((key, value) -> value.forEach(e -> sb.append((String)key).append(EQ).append((String)e).append(AND)));
            if (sb.lastIndexOf(AND) == sb.length() - 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            this.stringBuilder.append((CharSequence)sb);
        }
        try {
            return new URI(this.stringBuilder.toString());
        }
        catch (URISyntaxException e) {
            throw new ClientException(Problem.localProblem("could not create api url", null), (Throwable)e);
        }
    }

    private String urlEncode(String param) {
        try {
            return URLEncoder.encode(param, UTF_8.name()).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException(Problem.localProblem("Could not encode param", "param=[" + param + "]"), (Throwable)e);
        }
    }
}

