/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import nakadi.AuthorizationException;
import nakadi.ClientException;
import nakadi.ConflictException;
import nakadi.ContractException;
import nakadi.Cursor;
import nakadi.CursorCommitResult;
import nakadi.CursorCommitResultCollection;
import nakadi.ExponentialRetry;
import nakadi.InvalidException;
import nakadi.LinkSupport;
import nakadi.MetricCollector;
import nakadi.NakadiClient;
import nakadi.NakadiException;
import nakadi.NotFoundException;
import nakadi.PaginationLinks;
import nakadi.Problem;
import nakadi.QueryParams;
import nakadi.RateLimitException;
import nakadi.Resource;
import nakadi.ResourceCollection;
import nakadi.ResourceLink;
import nakadi.ResourceOptions;
import nakadi.ResourceSupport;
import nakadi.Response;
import nakadi.RetryPolicy;
import nakadi.ServerException;
import nakadi.Subscription;
import nakadi.SubscriptionCollection;
import nakadi.SubscriptionCursorCollection;
import nakadi.SubscriptionEventTypeStats;
import nakadi.SubscriptionEventTypeStatsCollection;
import nakadi.SubscriptionResource;
import nakadi.UriBuilder;
import nakadi.VisibleForTesting;
import nakadi.shadow.com.google.gson.reflect.TypeToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionResourceReal
implements SubscriptionResource {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());
    private static final String PATH_CURSORS = "cursors";
    private static final String PATH_STATS = "stats";
    private static final String PATH = "subscriptions";
    private static final String APPLICATION_JSON = "application/json";
    private static final Type TYPE_CURSOR_COMMIT_RESULT = new TypeToken<CursorCommitResultCollection>(){}.getType();
    private static final Type TYPE = new TypeToken<List<Subscription>>(){}.getType();
    private final NakadiClient client;
    private CursorCommitResultCollection sentinelCursorCommitResultCollection;
    private volatile RetryPolicy retryPolicy;

    SubscriptionResourceReal(NakadiClient client) {
        this.client = client;
        this.sentinelCursorCommitResultCollection = new CursorCommitResultCollection(new ArrayList<CursorCommitResult>(), new ArrayList<ResourceLink>(), this, client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response timed(Supplier<Response> sender, NakadiClient client, MetricCollector.Timer timer) {
        long start = System.nanoTime();
        try {
            Response response = sender.get();
            return response;
        }
        finally {
            try {
                client.metricCollector().duration(timer, System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    @Deprecated
    public SubscriptionResource scope(String scope) {
        return this;
    }

    @Override
    public SubscriptionResource retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Override
    public Response createReturningResponse(Subscription subscription) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        NakadiException.throwNonNull(subscription, "Please provide a subscription");
        ResourceOptions options = this.prepareOptions();
        return this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("POST", this.collectionUri().buildString(), options, () -> this.client.jsonSupport().toJsonBytes(subscription));
    }

    @Override
    public Subscription create(Subscription subscription) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, ConflictException, NakadiException {
        NakadiException.throwNonNull(subscription, "Please provide a subscription");
        ResourceOptions options = this.prepareOptions();
        return this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("POST", this.collectionUri().buildString(), options, () -> this.client.jsonSupport().toJsonBytes(subscription), Subscription.class);
    }

    @Override
    public Subscription find(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        NakadiException.throwNonNull(id, "Please provide an id");
        String url = this.collectionUri().path(id).buildString();
        ResourceOptions options = this.prepareOptions();
        return this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, options, Subscription.class);
    }

    @Override
    public Optional<Subscription> tryFind(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        try {
            return Optional.of(this.find(id));
        }
        catch (NotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public SubscriptionCollection list() throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        return this.list(new QueryParams());
    }

    @Override
    public SubscriptionCollection list(QueryParams params) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        NakadiException.throwNonNull(params, "Please provide query params");
        return this.loadPage(this.collectionUri().query(params).buildString());
    }

    @Override
    public Response delete(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        NakadiException.throwNonNull(id, "Please provide an id");
        String url = this.collectionUri().path(id).buildString();
        ResourceOptions options = this.prepareOptions();
        return this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("DELETE", url, options);
    }

    @Override
    public CursorCommitResultCollection checkpoint(Map<String, String> context, Cursor ... cursors) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, ContractException, NakadiException {
        return this.checkpoint(this.retryPolicy, context, cursors);
    }

    @Override
    public Response reset(String id, List<Cursor> cursors) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, ConflictException, NakadiException {
        NakadiException.throwNonNull(id, "Please provide an id");
        NakadiException.throwNonNull(cursors, "Please provide a cursors list");
        return this.reset(this.retryPolicy, id, cursors);
    }

    @Override
    public SubscriptionCursorCollection cursors(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        NakadiException.throwNonNull(id, "Please provide an id");
        return this.loadCursorPage(this.collectionUri().path(id).path(PATH_CURSORS).buildString());
    }

    @Override
    public SubscriptionEventTypeStatsCollection stats(String id) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException, NakadiException {
        NakadiException.throwNonNull(id, "Please provide an id");
        return this.loadStatsPage(this.collectionUri().path(id).path(PATH_STATS).buildString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    CursorCommitResultCollection checkpoint(RetryPolicy backoff, Map<String, String> context, Cursor ... cursors) {
        NakadiException.throwNonNull(cursors, "Please provide cursors");
        NakadiException.throwNonNull(context, "Please provide a context map");
        NakadiException.throwNonNull(context.get("X-Nakadi-StreamId"), "Please provide the header X-Nakadi-StreamId");
        NakadiException.throwNonNull(context.get("SubscriptionId"), "Please provide the subscription id");
        List<Cursor> cursorList = Arrays.asList(cursors);
        HashMap<String, List<Cursor>> requestMap = new HashMap<String, List<Cursor>>();
        requestMap.put("items", cursorList);
        String streamId = context.get("X-Nakadi-StreamId");
        String subscriptionId = context.get("SubscriptionId");
        String url = this.collectionUri().path(subscriptionId).path(PATH_CURSORS).buildString();
        ResourceOptions options = this.prepareOptions();
        options.header("X-Nakadi-StreamId", streamId);
        Resource resource = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy);
        try (Response response = null;){
            MetricCollector.Timer timer = MetricCollector.Timer.checkpointSend;
            response = SubscriptionResourceReal.timed(() -> resource.requestThrowing("POST", url, options, () -> this.client.jsonSupport().toJsonBytes(requestMap)), this.client, timer);
            if (response.statusCode() == 204) {
                CursorCommitResultCollection cursorCommitResultCollection = this.sentinelCursorCommitResultCollection;
                return cursorCommitResultCollection;
            }
            if (response.statusCode() == 200) {
                String raw = response.responseBody().asString();
                CursorCommitResultCollection cursorCommitResultCollection = (CursorCommitResultCollection)this.client.jsonSupport().fromJson(raw, TYPE_CURSOR_COMMIT_RESULT);
                return cursorCommitResultCollection;
            }
        }
        throw new ContractException(Problem.contractProblem("Success committing cursor with unexpected code", "response: " + response));
    }

    SubscriptionEventTypeStatsCollection loadStatsPage(String url) {
        ResourceOptions options = this.prepareOptions();
        Response response = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, options);
        SubscriptionEventTypeStatsList cursors = this.client.jsonSupport().fromJson(response.responseBody().asString(), SubscriptionEventTypeStatsList.class);
        List<SubscriptionEventTypeStats> items = cursors.items();
        return new SubscriptionEventTypeStatsCollection(items, new ArrayList<ResourceLink>(), this, this.client);
    }

    SubscriptionCursorCollection loadCursorPage(String url) {
        ResourceOptions options = this.prepareOptions();
        Response response = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, options);
        SubscriptionCursorList cursors = this.client.jsonSupport().fromJson(response.responseBody().asString(), SubscriptionCursorList.class);
        List<Cursor> items = cursors.items();
        return new SubscriptionCursorCollection(items, new ArrayList<ResourceLink>(), this, this.client);
    }

    SubscriptionCollection loadPage(String url) {
        ResourceOptions options = this.prepareOptions();
        Response response = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, options);
        SubscriptionList list = this.client.jsonSupport().fromJson(response.responseBody().asString(), SubscriptionList.class);
        return new SubscriptionCollection(this.toSubscriptions(list.items()), this.toLinks(list._links()), this, this.client);
    }

    private Response reset(RetryPolicy retryPolicy, String id, List<Cursor> cursors) {
        Resource resource = this.client.resourceProvider().newResource().retryPolicy(retryPolicy);
        String url = this.collectionUri().path(id).path(PATH_CURSORS).buildString();
        ResourceOptions options = this.prepareOptions();
        List<Cursor> cleaned = Cursor.prepareRequiringEventType(cursors);
        return SubscriptionResourceReal.timed(() -> resource.requestThrowing("PATCH", url, options, () -> this.client.jsonSupport().toJsonBytes(new CursorResetCollection(cleaned))), this.client, MetricCollector.Timer.cursorReset);
    }

    private List<ResourceLink> toLinks(PaginationLinks _links) {
        return new LinkSupport().toLinks(_links);
    }

    private List<Subscription> toSubscriptions(List<Subscription> items) {
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        if (items != null) {
            subscriptions.addAll(items);
        }
        return subscriptions;
    }

    private ResourceOptions prepareOptions() {
        return ResourceSupport.options(APPLICATION_JSON).tokenProvider(this.client.resourceTokenProvider());
    }

    private UriBuilder collectionUri() {
        return UriBuilder.builder(this.client.baseURI()).path(PATH);
    }

    ResourceCollection<CursorCommitResult> loadCursorCommitPage(String url) {
        return new CursorCommitResultCollection(this.loadCollection(url), new ArrayList<ResourceLink>(), this, this.client);
    }

    private List<CursorCommitResult> loadCollection(String url) {
        ResourceOptions options = this.prepareOptions();
        Response response = this.client.resourceProvider().newResource().retryPolicy(this.retryPolicy).requestThrowing("GET", url, options);
        return (List)this.client.jsonSupport().fromJson(response.responseBody().asString(), TYPE);
    }

    private RetryPolicy policyBackoffForCheckpoint() {
        return ExponentialRetry.newBuilder().initialInterval(900L, TimeUnit.MILLISECONDS).maxAttempts(3).maxInterval(2000L, TimeUnit.MILLISECONDS).build();
    }

    private static class SubscriptionEventTypeStatsList {
        private final List<SubscriptionEventTypeStats> items = new ArrayList<SubscriptionEventTypeStats>();

        private SubscriptionEventTypeStatsList() {
        }

        List<SubscriptionEventTypeStats> items() {
            return this.items;
        }
    }

    private static class SubscriptionCursorList {
        private final List<Cursor> items = new ArrayList<Cursor>();

        private SubscriptionCursorList() {
        }

        List<Cursor> items() {
            return this.items;
        }
    }

    private static class SubscriptionList {
        private final PaginationLinks _links = null;
        private final List<Subscription> items = new ArrayList<Subscription>();

        private SubscriptionList() {
        }

        PaginationLinks _links() {
            return this._links;
        }

        List<Subscription> items() {
            return this.items;
        }
    }

    @VisibleForTesting
    static class CursorResetCollection {
        final List<Cursor> items;

        CursorResetCollection(List<Cursor> items) {
            this.items = items;
        }
    }
}

