/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import nakadi.NakadiClient;
import nakadi.StreamCursorContext;
import nakadi.StreamOffsetObserver;
import nakadi.SubscriptionOffsetCheckpointer;
import nakadi.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class SubscriptionOffsetObserver
implements StreamOffsetObserver {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());
    private final SubscriptionOffsetCheckpointer checkpointer;

    public SubscriptionOffsetObserver(SubscriptionOffsetCheckpointer checkpointer) {
        this.checkpointer = checkpointer;
    }

    @Override
    public void onNext(StreamCursorContext context) {
        try {
            MDC.put((String)"cursor_context", (String)context.toString());
            logger.debug("subscription_checkpoint starting checkpoint {}", (Object)context);
            this.checkpoint(context);
        }
        finally {
            MDC.remove((String)"cursor_context");
        }
    }

    private void checkpoint(StreamCursorContext context) {
        this.checkpointer().checkpoint(context);
    }

    @VisibleForTesting
    SubscriptionOffsetCheckpointer checkpointer() {
        return this.checkpointer;
    }
}

