/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nakadi.AuthorizationAttribute;
import nakadi.NakadiException;
import nakadi.shadow.com.google.common.collect.ImmutableList;

public class SubscriptionAuthorization {
    private List<AuthorizationAttribute> admins;
    private List<AuthorizationAttribute> readers;

    public List<AuthorizationAttribute> admins() {
        return ImmutableList.copyOf(this.admins);
    }

    public SubscriptionAuthorization admins(List<AuthorizationAttribute> admins) {
        NakadiException.throwNonNull(admins, "Please provide a non-null admin authorization list");
        this.guardAdmins();
        this.admins.addAll(admins);
        return this;
    }

    public List<AuthorizationAttribute> readers() {
        return ImmutableList.copyOf(this.readers);
    }

    public SubscriptionAuthorization readers(List<AuthorizationAttribute> readers) {
        NakadiException.throwNonNull(readers, "Please provide a non-null readers authorization list");
        this.guardReaders();
        this.readers.addAll(readers);
        return this;
    }

    public SubscriptionAuthorization admin(AuthorizationAttribute admin) {
        NakadiException.throwNonNull(admin, "Please provide a non-null admin authorization");
        this.guardAdmins();
        this.admins.add(admin);
        return this;
    }

    public SubscriptionAuthorization reader(AuthorizationAttribute reader) {
        NakadiException.throwNonNull(reader, "Please provide a non-null reader authorization");
        this.guardReaders();
        this.readers.add(reader);
        return this;
    }

    private void guardAdmins() {
        if (this.admins == null) {
            this.admins = new ArrayList<AuthorizationAttribute>();
        }
    }

    private void guardReaders() {
        if (this.readers == null) {
            this.readers = new ArrayList<AuthorizationAttribute>();
        }
    }

    public String toString() {
        return "EventTypeAuthorization{admins=" + this.admins + ", readers=" + this.readers + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionAuthorization that = (SubscriptionAuthorization)o;
        return Objects.equals(this.admins, that.admins) && Objects.equals(this.readers, that.readers);
    }

    public int hashCode() {
        return Objects.hash(this.admins, this.readers);
    }
}

