/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import nakadi.Cursor;
import nakadi.NakadiException;
import nakadi.SubscriptionAuthorization;

public class Subscription {
    private String id;
    private String owningApplication;
    private String consumerGroup;
    private String readFrom;
    private List<String> eventTypes = new ArrayList<String>();
    private OffsetDateTime createdAt;
    private List<Cursor> initialCursors;
    private SubscriptionAuthorization authorization;

    public String id() {
        return this.id;
    }

    Subscription id(String id) {
        this.id = id;
        return this;
    }

    public String owningApplication() {
        return this.owningApplication;
    }

    public Subscription owningApplication(String owningApplication) {
        NakadiException.throwNonNull(owningApplication, "Please supply a non-null cowning application");
        this.owningApplication = owningApplication;
        return this;
    }

    public String consumerGroup() {
        return this.consumerGroup;
    }

    public Subscription consumerGroup(String consumerGroup) {
        NakadiException.throwNonNull(consumerGroup, "Please supply a non-null consumer group name");
        this.consumerGroup = consumerGroup;
        return this;
    }

    public String readFrom() {
        return this.readFrom;
    }

    public Subscription readFrom(String readFrom) {
        NakadiException.throwNonNull(readFrom, "Please supply a non-null read from value");
        this.readFrom = readFrom;
        return this;
    }

    public List<String> eventTypes() {
        return this.eventTypes;
    }

    public Subscription eventTypes(String ... eventTypeNames) {
        NakadiException.throwNonNull(eventTypeNames, "Please supply a non-null list of event type names");
        this.eventTypes.addAll(Arrays.asList(eventTypeNames));
        return this;
    }

    public Subscription eventType(String eventTypeName) {
        NakadiException.throwNonNull(eventTypeName, "Please supply a non-null event type name");
        this.eventTypes.add(eventTypeName);
        return this;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public List<Cursor> initialCursors() {
        return this.initialCursors;
    }

    public Subscription initialCursors(List<Cursor> initialCursors) {
        NakadiException.throwNotNullOrEmpty(initialCursors, "Please supply a non-null non-empty list of cursors");
        this.initialCursors = this.prepareCursors(initialCursors);
        return this;
    }

    public SubscriptionAuthorization authorization() {
        return this.authorization;
    }

    public Subscription authorization(SubscriptionAuthorization authorization) {
        this.authorization = authorization;
        return this;
    }

    private List<Cursor> prepareCursors(List<Cursor> cursors) {
        return Cursor.prepareRequiringEventType(cursors);
    }

    private Cursor newSubscriptionCursor(Cursor cursor) {
        return Cursor.prepareRequiringEventType(cursor);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.owningApplication, this.consumerGroup, this.readFrom, this.eventTypes, this.createdAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.owningApplication, that.owningApplication) && Objects.equals(this.consumerGroup, that.consumerGroup) && Objects.equals(this.readFrom, that.readFrom) && Objects.equals(this.eventTypes, that.eventTypes) && Objects.equals(this.createdAt, that.createdAt);
    }

    public String toString() {
        return "Subscription{id='" + this.id + '\'' + ", owningApplication='" + this.owningApplication + '\'' + ", consumerGroup='" + this.consumerGroup + '\'' + ", readFrom='" + this.readFrom + '\'' + ", eventTypes=" + this.eventTypes + ", createdAt=" + this.createdAt + ", authorization='" + this.authorization + '\'' + '}';
    }
}

