/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import nakadi.Cursor;
import nakadi.NakadiClient;
import nakadi.ResourceOptions;
import nakadi.ResourceSupport;
import nakadi.StreamConfiguration;
import nakadi.UriBuilder;

class StreamResourceSupport {
    public static final String X_NAKADI_STREAM_ID = "X-Nakadi-StreamId";
    public static final String SUBSCRIPTION_ID = "SubscriptionId";
    private static final String PARAM_BATCH_LIMIT = "batch_limit";
    private static final String PARAM_STREAM_LIMIT = "stream_limit";
    private static final String PARAM_BATCH_FLUSH_TIMEOUT = "batch_flush_timeout";
    private static final String PARAM_STREAM_TIMEOUT = "stream_timeout";
    private static final String PARAM_COMMIT_TIMEOUT = "commit_timeout";
    private static final String PARAM_STREAM_KEEP_ALIVE_LIMIT = "stream_keep_alive_limit";
    private static final String PARAM_MAX_UNCOMMITTED_EVENTS = "max_uncommitted_events";
    private static final String PATH_EVENT_TYPES = "event-types";
    private static final String PATH_SUBS = "subscriptions";
    private static final String PATH_EVENTS = "events";
    private static final String APPLICATION_X_JSON_STREAM = "application/x-json-stream";
    private static final String APPLICATION_JSON = "application/json";
    private static final String HEADER_X_NAKADI_CURSORS = "X-Nakadi-Cursors";

    StreamResourceSupport() {
    }

    static String buildStreamUrl(URI baseUri, StreamConfiguration sc) {
        UriBuilder uriBuilder = UriBuilder.builder(baseUri);
        if (sc.isSubscriptionStream()) {
            uriBuilder.path(PATH_SUBS).path(sc.subscriptionId()).path(PATH_EVENTS);
            uriBuilder = StreamResourceSupport.applySubscriptionQueryParamsTo(uriBuilder, sc);
        } else {
            uriBuilder.path(PATH_EVENT_TYPES).path(sc.eventTypeName()).path(PATH_EVENTS);
            uriBuilder = StreamResourceSupport.applyParamsTo(uriBuilder, sc);
        }
        return uriBuilder.buildString();
    }

    static ResourceOptions buildResourceOptions(NakadiClient client, StreamConfiguration sc) {
        ResourceOptions options = ResourceSupport.options(APPLICATION_JSON).tokenProvider(client.resourceTokenProvider());
        StreamResourceSupport.applyConfiguredHeaders(sc, options);
        if (sc.isSubscriptionStream()) {
            return options;
        }
        Optional<List<Cursor>> cursors = sc.cursors();
        cursors.ifPresent(list -> options.header(HEADER_X_NAKADI_CURSORS, client.jsonSupport().toJsonCompressed(list)));
        return options;
    }

    private static void applyConfiguredHeaders(StreamConfiguration sc, ResourceOptions options) {
        sc.requestHeaders().forEach(options::header);
    }

    private static UriBuilder applyParamsTo(UriBuilder uriBuilder, StreamConfiguration sc) {
        if (sc.batchLimit() > 1) {
            uriBuilder.query(PARAM_BATCH_LIMIT, "" + sc.batchLimit());
        }
        if (sc.streamLimit() != 0) {
            uriBuilder.query(PARAM_STREAM_LIMIT, "" + sc.streamLimit());
        }
        if (sc.batchFlushTimeoutSeconds() != 30L) {
            uriBuilder.query(PARAM_BATCH_FLUSH_TIMEOUT, "" + sc.batchFlushTimeoutSeconds());
        }
        if (sc.streamTimeoutSeconds() != 0L) {
            uriBuilder.query(PARAM_STREAM_TIMEOUT, "" + sc.streamTimeoutSeconds());
        }
        if (sc.streamKeepAliveLimit() != 0) {
            uriBuilder.query(PARAM_STREAM_KEEP_ALIVE_LIMIT, "" + sc.streamKeepAliveLimit());
        }
        if (sc.commitTimeoutSeconds() != 60L) {
            uriBuilder.query(PARAM_COMMIT_TIMEOUT, "" + sc.commitTimeoutSeconds());
        }
        return uriBuilder;
    }

    private static UriBuilder applySubscriptionQueryParamsTo(UriBuilder uriBuilder, StreamConfiguration sc) {
        if (sc.maxUncommittedEvents() != 10L) {
            uriBuilder.query(PARAM_MAX_UNCOMMITTED_EVENTS, "" + sc.maxUncommittedEvents());
        }
        return StreamResourceSupport.applyParamsTo(uriBuilder, sc);
    }
}

