/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import nakadi.NakadiClient;
import nakadi.Resource;
import nakadi.ResourceOptions;
import nakadi.Response;
import nakadi.StreamConfiguration;
import nakadi.StreamProcessor;
import nakadi.StreamResourceSupport;
import nakadi.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamProcessorRequestFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());
    private final NakadiClient client;

    StreamProcessorRequestFactory(NakadiClient client) {
        this.client = client;
    }

    Callable<Response> createCallable(StreamConfiguration sc, StreamProcessor streamProcessor) {
        return () -> this.onCall(sc, streamProcessor);
    }

    @VisibleForTesting
    Response onCall(StreamConfiguration sc, StreamProcessor streamProcessor) throws Exception {
        String url = StreamResourceSupport.buildStreamUrl(this.client.baseURI(), sc);
        ResourceOptions options = StreamResourceSupport.buildResourceOptions(this.client, sc);
        String mode = sc.isEventTypeStream() ? "eventStream" : "subscriptionStream";
        logger.debug("stream_connection_open step=request mode={} url={}", (Object)mode, (Object)url);
        Response response = this.requestStreamConnection(url, options, this.buildResource(sc));
        streamProcessor.currentStreamResponseCode(response.statusCode());
        logger.info("stream_connection_open step=response hash={} response={} x_nakadi_stream_id={} ", new Object[]{response.hashCode(), response, response.headers().get("X-Nakadi-StreamId")});
        return response;
    }

    @VisibleForTesting
    Response requestStreamConnection(String url, ResourceOptions options, Resource resource) {
        return resource.requestThrowing("GET", url, options);
    }

    @VisibleForTesting
    Resource buildResource(StreamConfiguration sc) {
        return this.client.resourceProvider().newResource().readTimeout(sc.readTimeoutMillis(), TimeUnit.MILLISECONDS).connectTimeout(sc.connectTimeoutMillis(), TimeUnit.MILLISECONDS);
    }
}

