/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.concurrent.TimeUnit;
import nakadi.NakadiClient;
import nakadi.shadow.io.reactivex.Flowable;
import nakadi.shadow.io.reactivex.FlowableTransformer;
import nakadi.shadow.io.reactivex.functions.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamConnectionRestart {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());
    static long DEFAULT_DELAY_SECONDS = 3L;
    static TimeUnit DEFAULT_DELAY_UNIT = TimeUnit.SECONDS;
    static int DEFAULT_MAX_RESTARTS = Integer.MAX_VALUE;

    StreamConnectionRestart() {
    }

    <T> FlowableTransformer<T, T> repeatWhenWithDelayAndUntil(Predicate<Long> stopRestartingPredicate, long restartDelay, TimeUnit restartDelayUnit, int maxRestarts) {
        return upstream -> upstream.repeatWhen(flowable -> flowable.zipWith(Flowable.range(1, maxRestarts), (obj, count) -> count).flatMap(attemptCount -> {
            if (logger.isDebugEnabled()) {
                logger.debug("stream_repeater_delay delay={} {}, restarts={} max_restarts={}", new Object[]{restartDelay, restartDelayUnit.toString().toLowerCase(), attemptCount, maxRestarts});
            }
            return Flowable.timer(restartDelay, restartDelayUnit);
        }).takeUntil(stopRestartingPredicate));
    }
}

