/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import nakadi.Cursor;
import nakadi.NakadiException;
import nakadi.StreamConnectionRetryFlowable;
import nakadi.shadow.com.google.common.collect.ImmutableMap;

public class StreamConfiguration {
    static final int DEFAULT_BATCH_LIMIT = 1;
    static final int DEFAULT_STREAM_LIMIT = 0;
    static final int DEFAULT_BATCH_FLUSH_TIMEOUT = 30;
    static final int DEFAULT_STREAM_TIMEOUT = 0;
    static final int DEFAULT_COMMIT_TIMEOUT = 60;
    static final int DEFAULT_STREAM_KEEPALIVE_COUNT = 0;
    static final int DEFAULT_MAX_UNCOMMITTED_EVENTS = 10;
    private final Map<String, String> requestHeaders = new HashMap<String, String>();
    private int batchLimit = 1;
    private int streamLimit = 0;
    private long batchFlushTimeout = 30L;
    private long streamTimeout = 0L;
    private long commitTimeout = 60L;
    private int streamKeepAliveLimit = 0;
    private List<Cursor> cursors;
    private String topic;
    private String subscriptionId;
    private long maxUncommittedEvents = 10L;
    private long connectTimeout = 30000L;
    private long readTimeout = 60000L;
    private long maxRetryDelay = StreamConnectionRetryFlowable.DEFAULT_MAX_DELAY_SECONDS;
    private long minRetryDelay = StreamConnectionRetryFlowable.DEFAULT_MIN_DELAY_SECONDS;
    private int maxRetryAttempts = StreamConnectionRetryFlowable.DEFAULT_MAX_ATTEMPTS;
    private int batchBufferCount = 128;

    public String eventTypeName() {
        return this.topic;
    }

    public StreamConfiguration eventTypeName(String topic) {
        this.topic = topic;
        return this;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public StreamConfiguration subscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public long connectTimeoutMillis() {
        return this.connectTimeout;
    }

    public StreamConfiguration connectTimeout(long timeout, TimeUnit unit) {
        this.connectTimeout = unit.toMillis(timeout);
        return this;
    }

    public long readTimeoutMillis() {
        return this.readTimeout;
    }

    public StreamConfiguration readTimeout(long timeout, TimeUnit unit) {
        this.readTimeout = unit.toMillis(timeout);
        return this;
    }

    public long maxUncommittedEvents() {
        return this.maxUncommittedEvents;
    }

    public StreamConfiguration maxUncommittedEvents(long maxUncommittedEvents) {
        this.maxUncommittedEvents = maxUncommittedEvents;
        return this;
    }

    public int batchLimit() {
        return this.batchLimit;
    }

    public StreamConfiguration batchLimit(int batchLimit) {
        this.batchLimit = batchLimit;
        return this;
    }

    public int streamLimit() {
        return this.streamLimit;
    }

    public StreamConfiguration streamLimit(int streamLimit) {
        this.streamLimit = streamLimit;
        return this;
    }

    public long batchFlushTimeoutSeconds() {
        return this.batchFlushTimeout;
    }

    public StreamConfiguration batchFlushTimeout(long batchFlushTimeout, TimeUnit unit) {
        this.batchFlushTimeout = unit.toSeconds(batchFlushTimeout);
        return this;
    }

    public long streamTimeoutSeconds() {
        return this.streamTimeout;
    }

    public StreamConfiguration streamTimeout(long streamTimeout, TimeUnit unit) {
        this.streamTimeout = unit.toSeconds(streamTimeout);
        return this;
    }

    public long commitTimeoutSeconds() {
        return this.commitTimeout;
    }

    public StreamConfiguration commitTimeout(long commitTimeout, TimeUnit unit) {
        this.commitTimeout = unit.toSeconds(commitTimeout);
        return this;
    }

    public int streamKeepAliveLimit() {
        return this.streamKeepAliveLimit;
    }

    public StreamConfiguration streamKeepAliveLimit(int streamKeepAliveLimit) {
        this.streamKeepAliveLimit = streamKeepAliveLimit;
        return this;
    }

    public Optional<List<Cursor>> cursors() {
        return Optional.ofNullable(this.cursors);
    }

    public StreamConfiguration cursors(Cursor ... cursors) {
        NakadiException.throwNonNull(cursors, "Please provide at least one cursor");
        if (this.cursors == null) {
            this.cursors = new ArrayList<Cursor>();
        }
        this.cursors.addAll(Arrays.asList(cursors));
        return this;
    }

    public StreamConfiguration cursor(Cursor cursor) {
        NakadiException.throwNonNull(cursor, "Please provide a cursor");
        return this.cursors(cursor);
    }

    public long maxRetryDelaySeconds() {
        return this.maxRetryDelay;
    }

    public StreamConfiguration maxRetryDelay(long maxRetryDelay, TimeUnit unit) throws IllegalArgumentException {
        NakadiException.throwNonNull(unit, "Please provide a time unit for max retry delay");
        if (TimeUnit.SECONDS.toMillis(this.minRetryDelay) > unit.toMillis(maxRetryDelay)) {
            throw new IllegalArgumentException("supplied max delay cannot be less than " + this.minRetryDelay + "s");
        }
        this.maxRetryDelay = unit.toSeconds(maxRetryDelay);
        return this;
    }

    public int maxRetryAttempts() {
        return this.maxRetryAttempts;
    }

    public StreamConfiguration maxRetryAttempts(int maxRetryAttempts) {
        this.maxRetryAttempts = maxRetryAttempts;
        return this;
    }

    public Map<String, String> requestHeaders() {
        return ImmutableMap.copyOf(this.requestHeaders);
    }

    public StreamConfiguration requestHeaders(Map<String, String> headers) {
        NakadiException.throwNonNull(headers, "Please provide non null request headers");
        this.requestHeaders.putAll(headers);
        return this;
    }

    public StreamConfiguration requestHeader(String name, String value) {
        NakadiException.throwNonNull(name, "Please provide a header name");
        NakadiException.throwNonNull(value, "Please provide a header value");
        this.requestHeaders.put(name, value);
        return this;
    }

    public StreamConfiguration batchBufferCount(int eventBufferSize) {
        if (eventBufferSize <= 0) {
            throw new IllegalArgumentException("Please provide a batch buffer count greater than 0, received: " + eventBufferSize);
        }
        this.batchBufferCount = eventBufferSize;
        return this;
    }

    public int batchBufferCount() {
        return this.batchBufferCount;
    }

    boolean isSubscriptionStream() {
        return this.subscriptionId() != null;
    }

    boolean isEventTypeStream() {
        return this.eventTypeName() != null;
    }

    public int hashCode() {
        return Objects.hash(this.batchLimit, this.streamLimit, this.batchFlushTimeout, this.streamTimeout, this.streamKeepAliveLimit, this.cursors, this.connectTimeout, this.readTimeout, this.batchBufferCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamConfiguration that = (StreamConfiguration)o;
        return this.batchLimit == that.batchLimit && this.streamLimit == that.streamLimit && this.batchFlushTimeout == that.batchFlushTimeout && this.streamTimeout == that.streamTimeout && this.streamKeepAliveLimit == that.streamKeepAliveLimit && this.connectTimeout == that.connectTimeout && this.readTimeout == that.readTimeout && this.batchBufferCount == that.batchBufferCount && Objects.equals(this.cursors, that.cursors);
    }

    public String toString() {
        return "StreamConfiguration{batchLimit=" + this.batchLimit + ", streamLimit=" + this.streamLimit + ", batchFlushTimeout=" + this.batchFlushTimeout + ", streamTimeout=" + this.streamTimeout + ", streamKeepAliveLimit=" + this.streamKeepAliveLimit + ", cursors=" + this.cursors + ", connectTimeoutMillis=" + this.connectTimeout + ", readTimeoutMillis=" + this.readTimeout + ", batchBufferCount=" + this.batchBufferCount + '}';
    }
}

