/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.util.Map;
import java.util.Objects;
import nakadi.EventStreamBatch;
import nakadi.StreamBatch;
import nakadi.StreamBatchReal;
import nakadi.StreamBatchRecord;
import nakadi.StreamCursorContext;
import nakadi.StreamCursorContextReal;
import nakadi.StreamOffsetObserver;

class StreamBatchRecordReal<T>
implements StreamBatchRecord<T> {
    private final StreamBatch<T> streamBatchRecord;
    private final StreamCursorContext streamCursorContext;
    private final StreamOffsetObserver streamOffsetObserver;
    private String streamIdHeader;

    StreamBatchRecordReal(EventStreamBatch<T> batch, StreamOffsetObserver streamOffsetObserver, Map<String, String> context) {
        Objects.requireNonNull(batch);
        Objects.requireNonNull(streamOffsetObserver);
        Objects.requireNonNull(context);
        this.streamOffsetObserver = streamOffsetObserver;
        this.streamBatchRecord = new StreamBatchReal<T>(batch);
        this.streamCursorContext = new StreamCursorContextReal(this.streamBatchRecord.cursor(), context);
    }

    StreamBatchRecordReal(EventStreamBatch<T> batch, StreamOffsetObserver streamOffsetObserver) {
        Objects.requireNonNull(batch);
        Objects.requireNonNull(streamOffsetObserver);
        this.streamOffsetObserver = streamOffsetObserver;
        this.streamBatchRecord = new StreamBatchReal<T>(batch);
        this.streamCursorContext = new StreamCursorContextReal(this.streamBatchRecord.cursor());
    }

    @Override
    public StreamBatch<T> streamBatch() {
        return this.streamBatchRecord;
    }

    @Override
    public StreamCursorContext streamCursorContext() {
        return this.streamCursorContext;
    }

    @Override
    public StreamOffsetObserver streamOffsetObserver() {
        return this.streamOffsetObserver;
    }

    public int hashCode() {
        return Objects.hash(this.streamBatchRecord, this.streamCursorContext, this.streamOffsetObserver, this.streamIdHeader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamBatchRecordReal that = (StreamBatchRecordReal)o;
        return Objects.equals(this.streamBatchRecord, that.streamBatchRecord) && Objects.equals(this.streamCursorContext, that.streamCursorContext) && Objects.equals(this.streamOffsetObserver, that.streamOffsetObserver) && Objects.equals(this.streamIdHeader, that.streamIdHeader);
    }

    public String toString() {
        return "StreamBatchRecordReal{streamBatchRecord=" + this.streamBatchRecord + ", streamCursorContext=" + this.streamCursorContext + ", streamOffsetObserver=" + this.streamOffsetObserver + ", streamIdHeader='" + this.streamIdHeader + '\'' + '}';
    }
}

