/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.io.IOException;
import nakadi.shadow.okhttp3.Interceptor;
import nakadi.shadow.okhttp3.MediaType;
import nakadi.shadow.okhttp3.Request;
import nakadi.shadow.okhttp3.RequestBody;
import nakadi.shadow.okhttp3.Response;
import nakadi.shadow.okio.BufferedSink;
import nakadi.shadow.okio.GzipSink;
import nakadi.shadow.okio.Okio;

final class SpikeGzipRequestInterceptor
implements Interceptor {
    SpikeGzipRequestInterceptor() {
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        if (originalRequest.body() == null || originalRequest.header("Content-Encoding") != null) {
            return chain.proceed(originalRequest);
        }
        if (originalRequest.method().equals("POST")) {
            return chain.proceed(originalRequest);
        }
        RequestBody body = this.gzipCompress(originalRequest.body());
        Request compressedRequest = originalRequest.newBuilder().header("Content-Encoding", "gzip").header("Transfer-Encoding", "chunked").method(originalRequest.method(), body).build();
        return chain.proceed(compressedRequest);
    }

    RequestBody gzipCompress(final RequestBody body) {
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return body.contentType();
            }

            @Override
            public long contentLength() {
                return -1L;
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                try (BufferedSink gzipSink = Okio.buffer(new GzipSink(sink));){
                    body.writeTo(gzipSink);
                }
            }
        };
    }
}

