/*
 * Decompiled with CFR 0.152.
 */
package nakadi;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import nakadi.NakadiClient;
import nakadi.NakadiException;
import nakadi.Problem;
import nakadi.VisibleForTesting;
import nakadi.shadow.com.google.common.io.Resources;
import nakadi.shadow.okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SecuritySupport {
    private static final Logger logger = LoggerFactory.getLogger((String)NakadiClient.class.getSimpleName());
    private final String certificatePath;
    private SSLContext sslContext;
    private X509TrustManager trustManager;

    public SecuritySupport(String certificatePath) {
        try {
            MDC.put((String)"security_context", (String)"[security_support]");
            this.certificatePath = certificatePath;
            this.create(this.certificatePath);
        }
        finally {
            MDC.remove((String)"security_context");
        }
    }

    private static URL getResourceUrl(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        classLoader = classLoader == null ? SecuritySupport.class.getClassLoader() : classLoader;
        URL url = classLoader.getResource(resourceName);
        NakadiException.throwNonNull(url, "resource not found: " + resourceName);
        return url;
    }

    @VisibleForTesting
    static Path resolvePath(String certificatePath) {
        if (certificatePath.startsWith("file:")) {
            try {
                logger.info("using file resolver for {}", (Object)certificatePath);
                Path path = Paths.get(new URL(certificatePath).toURI());
                if (!Files.exists(path, new LinkOption[0])) {
                    throw new FileNotFoundException();
                }
                return path;
            }
            catch (Exception e) {
                throw new NakadiException(Problem.localProblem("certificatePath resolver failed " + certificatePath, e.getMessage()), (Throwable)e);
            }
        }
        if (SecuritySupport.isClasspath(certificatePath)) {
            logger.info("using classpath resolver for {}", (Object)certificatePath);
            return Paths.get(SecuritySupport.getResourceUrl(SecuritySupport.classpathBareName(certificatePath)).getPath(), new String[0]);
        }
        throw new NakadiException(Problem.localProblem("certificatePath must start with file: or classpath: " + certificatePath, ""));
    }

    private static boolean isClasspath(String certificatePath) {
        return certificatePath.startsWith("classpath:");
    }

    private static String classpathBareName(String certificatePath) {
        return certificatePath.substring("classpath:".length(), certificatePath.length());
    }

    void applySslSocketFactory(OkHttpClient.Builder builder) throws NakadiException {
        try {
            MDC.put((String)"security_context", (String)"[security_support]");
            if (this.certificatePath == null) {
                logger.info("no custom certificate path supplied, using system default");
                return;
            }
            builder.sslSocketFactory(this.sslContext.getSocketFactory(), this.trustManager);
            logger.info("ok, custom socket factory and trust manager added to builder");
        }
        finally {
            MDC.remove((String)"security_context");
        }
    }

    void create(String certificatePath) throws NakadiException {
        if (certificatePath == null) {
            logger.info("no custom certificate path supplied, skipping creation");
            return;
        }
        if (this.isSpecificClasspathResource(certificatePath)) {
            URL url = Resources.getResource(SecuritySupport.classpathBareName(certificatePath));
            try {
                byte[] bytes = Resources.toByteArray(url);
                this.create((KeyStore keyStore) -> this.installClasspathCertificate(certificatePath, bytes, (KeyStore)keyStore));
            }
            catch (Exception e) {
                throw new NakadiException(Problem.localProblem("configuring keystore failed, path " + certificatePath, e.getMessage()), (Throwable)e);
            }
            return;
        }
        Path path = SecuritySupport.resolvePath(certificatePath);
        try {
            logger.info("will create custom certs from path {}", (Object)path.toRealPath(new LinkOption[0]));
            this.create((KeyStore keyStore) -> this.installCertificates(path, (KeyStore)keyStore));
        }
        catch (Exception e) {
            throw new NakadiException(Problem.localProblem("configuring keystore failed, path " + certificatePath, e.getMessage()), (Throwable)e);
        }
    }

    private boolean isSpecificClasspathResource(String certificatePath) {
        return SecuritySupport.isClasspath(certificatePath) && (certificatePath.endsWith(".pem") || certificatePath.endsWith(".crt"));
    }

    private void create(Consumer<KeyStore> installer) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyManagementException {
        X509Certificate[] acceptedIssuers;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        installer.accept(keyStore);
        String defaultAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(defaultAlgorithm);
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        this.sslContext = SSLContext.getInstance("TLS");
        this.sslContext.init(null, trustManagers, null);
        this.trustManager = (X509TrustManager)trustManagers[0];
        for (X509Certificate acceptedIssuer : acceptedIssuers = this.trustManager.getAcceptedIssuers()) {
            logger.info("installed cert details: subject={} issuer={}", (Object)acceptedIssuer.getSubjectX500Principal(), (Object)acceptedIssuer.getIssuerX500Principal());
        }
    }

    private void installClasspathCertificate(String certificatePath, byte[] certData, KeyStore keyStore) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(certData);
            Certificate cert = certificateFactory.generateCertificate(bais);
            keyStore.setCertificateEntry(certificatePath, cert);
            logger.info("ok, installed cert with alias {} from classpath {}", (Object)certificatePath, (Object)certificatePath);
        }
        catch (KeyStoreException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private void installCertificates(Path path, KeyStore keyStore) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(path, "*.{crt,pem}");){
                for (Path certPath : paths) {
                    logger.info("installing cert from path {}", (Object)certPath.toRealPath(new LinkOption[0]));
                    if (Files.isRegularFile(certPath, new LinkOption[0])) {
                        try {
                            InputStream inputStream = Files.newInputStream(certPath, new OpenOption[0]);
                            Throwable throwable = null;
                            try {
                                Certificate cert = certificateFactory.generateCertificate(inputStream);
                                String alias = certPath.getFileName().toString();
                                keyStore.setCertificateEntry(alias, cert);
                                logger.info("ok, installed cert with alias {} from path {}", (Object)alias, (Object)certPath.toRealPath(new LinkOption[0]));
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (inputStream == null) continue;
                                if (throwable != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                inputStream.close();
                            }
                        }
                        catch (Exception e) {
                            logger.warn("error, skipping cert, path {} {}", (Object)certPath.toRealPath(new LinkOption[0]), (Object)e.getMessage());
                        }
                        continue;
                    }
                    logger.info("skipping cert, not a regular file {}", (Object)certPath.toRealPath(new LinkOption[0]));
                }
            }
        }
        catch (IOException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public X509TrustManager trustManager() {
        return this.trustManager;
    }
}

